#!/usr/bin/env python3
# Copyright (c) 2009-2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=simplifiable-if-statement
# pylint: disable=consider-using-in

import Tac, Tracing
import MlagMountHelper

handle = Tracing.Handle( 'EbraMlagDut' )

t0 = handle.trace0
t1 = handle.trace1
t2 = handle.trace2
t8 = handle.trace8
t9 = handle.trace9

mlagStatus_ = None
mlagHwStatus_ = None
mlagConfig_ = None
hostTable_ = None
brStatus = None
reactors_ = []

def isPeerMac( entryType ):
   if entryType == 'peerStaticMac' or \
         entryType == 'peerDynamicMac' or \
         entryType == 'peerConfiguredRemoteMac' or \
         entryType == 'peerLearnedRemoteMac' or \
         entryType == 'peerReceivedRemoteMac':
      return True 
   else:
      return False

def learningEnabled( vlanId, macAddr, portName, entryType ):
   if mlagStatus_.mlagState == 'inactive' or mlagStatus_.mlagState == 'disabled':
      # pylint: disable-next=consider-using-f-string
      t8( 'Skip learn check in mlag state %s' % mlagStatus_.mlagState )
      return 'learn'
   if entryType == 'configuredStaticMac':
      # Want to configure static entry on peer link
      # go ahead
      return 'learn'
   if( mlagStatus_.peerLinkIntf is not None ): # pylint: disable=superfluous-parens
      peerLinkIntfName = mlagStatus_.peerLinkIntf.intfId
      t8( 'learningEnabled on port', portName,
          '? peerLinkIntf is', peerLinkIntfName )
      if not entryType or not isPeerMac( entryType ):
         # Do not ignore the peer entries that we are programming
         # because they are programmed on peer.
         if( peerLinkIntfName == portName ): # pylint: disable=superfluous-parens
            t8( 'dont learn on this port' )
            return 'dontLearn'
   fdbStatus = brStatus.fdbStatus.get( vlanId )
   if fdbStatus:
      macEntry = fdbStatus.learnedHost.get( macAddr )
      if macEntry and macEntry.entryType == 'peerStaticMac':
         if entryType == 'learnedDynamicMac':
            # Do not overwrite a peer static entry with a local
            # dyamic entry
            return 'dontLearn'
   return 'learn'


def mlagFloodSuppress( bridge, finalIntfs, srcPort=None, dropReasonList=None,
                       vlanId=None, dstMacAddr=None, data=None ):
   t9( 'call to mlagFloodSuppress' )

   if not mlagConfig_.peerLinkIntfId:
      return

   if not hasattr( srcPort, 'intfConfig_' ):
      t9( 'No intfConfig_ (probably cpu port)' )
      return
   if not srcPort or not srcPort.intfConfig_ \
          or srcPort.intfConfig_.intfId != mlagConfig_.peerLinkIntfId:
      t9( 'Packet did not arrive from the peer link.' )
      return

   t9( 'Packet arrived on peer link; suppress flooding to active mlags' )
   for intf in list(finalIntfs):
      intfStatus = mlagStatus_.intfStatus.get( intf )
      if intfStatus and intfStatus.status == 'linkActive':
         t8( "Flooding suppressed by Mlag on", intf )
         del finalIntfs[ intf ]

def agentInit( em ):
   global mlagStatus_
   global mlagHwStatus_
   global mlagConfig_
   global hostTable_
   # Mount mlag/status, Mlag::Status and its dependent paths
   mlagStatus_ = MlagMountHelper.mountMlagStatus( em )
   mlagHwStatus_ = em.mount( 'mlag/hardware/status', 'Mlag::Hardware::Status', 'w' )
   mlagConfig_ = em.mount( 'mlag/config', 'Mlag::Config', 'r' )
   hostTable_ = em.mount( 'mlag/hostTable', 'Mlag::HostTable', 'rO' )

def bridgeInit( bridge ):
   global brStatus
   brStatus = bridge.brStatus_

def Plugin( ctx ):
   t2( 'MlagDut plugin registering' )
   ctx.registerAgentInitHandler( agentInit )
   ctx.registerBridgeInitHandler( bridgeInit )
   ctx.registerPacketReplicationHandler( mlagFloodSuppress )
   ctx.registerLearningHandler( learningEnabled )
