# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tracing
from EbraTestBridgePythonImpl import getPythonIntoCppShimContext
from EbraTestBridgePythonImpl import ArfaShimDestLookupHandlers
from EbraTestBridgePythonImpl import ArfaShimTrapLookupHandler

handle = Tracing.Handle( 'EbraTestBridgeMldSnooping' )
t2 = handle.trace2

etbaCtx = None

def bridgeInit( bridge ):
   t2( 'MldSnooping bridgeInit' )

   shim = getPythonIntoCppShimContext()
   assert shim

   plugin = shim.plugin( "MldSnooping" )
   assert plugin

   etbaCtx.registerDestLookupHandler(
      ArfaShimDestLookupHandlers( plugin.destLookupStep ) )
   etbaCtx.registerTrapLookupHandler(
      ArfaShimTrapLookupHandler( plugin.trapStep, True ) )

def Plugin( ctx ):
   global etbaCtx
   etbaCtx = ctx
   ctx.registerBridgeInitHandler( bridgeInit )
