# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tracing
import Tac
from EbraTestBridgePythonImpl import getPythonIntoCppShimContext

handle = Tracing.Handle( 'PdtEtbaPlugin' )
t0 = handle.trace0
t1 = handle.trace1

def performSampling( bridge, data, srcPort, finalIntfs ):
   t0( 'PostcardTelemetry Agent Sampling' )
   if not finalIntfs:
      t1( 'Dropped packet to simulate hardware behavior' )
      return

   outIntf = next( iter( finalIntfs ) )
   if outIntf.startswith( "Port-Channel" ):
      # If the chosen output interface is a LAG interface, choose one of the
      # member ports of the LAG
      lagPort = bridge.port[ outIntf ]
      if not lagPort.ports:
         t1( "No member port for dstPort %s. Packet dropped" % lagPort.name() )
         return
      outIntf = next( iter( lagPort.ports ) ).name()

   shim = getPythonIntoCppShimContext()
   assert shim

   pdtPlugin = shim.plugin( "PostcardTelemetry" )
   assert pdtPlugin
   pktCtx = shim.pktCtx( data, srcPort.name() )

   if srcPort.name().startswith( "Port-Channel" ):
      # Postcard Agent opens socket on ethernet intf
      # so use one member port if Port-channel intf
      if not srcPort.ports:
         t1( "No member port for srcPort %s. Packet dropped" % srcPort.name() )
         return
      memPort = srcPort.ports[ 0 ]
      lagInfo = Tac.newInstance( 'Arfa::LagPacketInfo' )
      lagInfo.origRxPort = memPort.name()
      pktCtx.pktInfo.addMember( lagInfo )

   cDstPort = shim.getPort( outIntf )
   pdtPlugin.pdtSamplerHelper.performSamplingArfa( pktCtx, cDstPort )


def Plugin( ctx ):
   t0( 'Entering Plugin( ctx ) in EbraTestBridgePlugin/PdtDut.py' )
   ctx.registerSflowHandler( performSampling )
