#!/usr/bin/env python3
# Copyright (c) 2008, 2009, 2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, Tracing
from EbraTestBridgePythonImpl import getPythonIntoCppShimContext

handle = Tracing.Handle( 'SflowEtbaPlugin' )
t0 = handle.trace0

def performSampling( bridge, data, srcPort, finalIntfs ):
   #Irregardless of what happens next,
   #we want to increment Total_Packets (sFlow V 5, pg 6)
   #XXX - probably Hw status... sflowStatus.totalPackets += 1

   shim = getPythonIntoCppShimContext()
   assert shim

   sflowPlugin = shim.plugin( "Sflow" )
   assert sflowPlugin

   sflowSampler = sflowPlugin.sflowSamplerHelper
   cSrcPort = shim.getPort( srcPort.name(), portMustExist=False )
   if not cSrcPort:
      t0( "No c port for", srcPort.name() )
      return
   pktCtx = shim.pktCtx( data, srcPort.name() )
   poMemberIntfHwOffload = sflowSampler.poMemberIntfHwOffload
   if sflowSampler.ingressEnabled( srcPort.name() ):
      sflowSampler.maybeSampleIngress( pktCtx, poMemberIntfHwOffload )
   else:
      for intf in finalIntfs:
         cDstPort = shim.getPort( intf )
         oCtx = Tac.newInstance(
            "Arfa::OutputPipelineContext", pktCtx, cDstPort, None )
         sflowSampler.maybeSampleEgress( oCtx, poMemberIntfHwOffload )

def Plugin( ctx ):
   if ctx.inArfaMode():
      # C++ plugin handles this
      return
   t0( 'Entering Plugin(ctx) in Sflow.py' )
   ctx.registerSflowHandler( performSampling )
