#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import TableOutput

def createTableOutput( table, headings, compact=False ):
   header = TableOutput.Headings( headings )
   # The first column is the a text identifier (cache or table name), and should
   # be left justified.
   rowLabelFmt = TableOutput.Format( justify="left", wrap=True )
   fmt = TableOutput.Format( justify="right", maxWidth=12, wrap=True )
   if compact:
      rowLabelFmt.padLimitIs( True )
      fmt.padLimitIs( True )
   header.formats = [ rowLabelFmt ] + [ fmt ] * ( len( headings ) - 1 )
   header.doApplyHeaders( table )

def getCacheMessage( cacheName ):
   if cacheName:
      return f'Cache {cacheName} does not exist'
   return 'No cache servers are configured'

def getCacheUnusedMessage( cacheNames ):
   printedList = ", ".join( sorted( cacheNames ) )
   return "The following caches are not running because too many caches " + \
      "have been configured: " + printedList

def getRoaTableMessage( roaTableName ):
   if roaTableName:
      return f'ROA table {roaTableName} does not exist'
   return 'No ROA tables are configured'

def getPartialTableRemovalNotSupportedMessage():
   return 'All RPKI ROA tables assigned to the cache server must be removed'
