#!/usr/bin/env python3
# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import grpc
import EosSdkRpc_pb2
from EosSdkRpc_pb2_grpc import eossdk_serviceStub as GrpcFibService
import sys
import Tac

class EosSdkRpcPurgeState:
   serviceAddr = '127.0.0.1:9543'

   rpcStatusOK = EosSdkRpc_pb2.rpc_status_msg.OK
   rpcStatusNOT_FOUND = EosSdkRpc_pb2.rpc_status_msg.NOT_FOUND
   rpcStatusFAIL = EosSdkRpc_pb2.rpc_status_msg.FAIL

   resyncStart = EosSdkRpc_pb2.rpc_server_resync_msg.START
   resyncEnd = EosSdkRpc_pb2.rpc_server_resync_msg.END

   def __init__( self ):
      self.client = None
      if len( sys.argv ) > 1:
         self.serviceAddr = sys.argv[ 1 ]
      print( 'Connecting to EosSdkRpc server' )
      self.reconnectClient()
      print( 'Start resync' )
      rpcStatus = self.client.rpc_server_resync(
         EosSdkRpc_pb2.rpc_server_resync_msg( value=self.resyncStart ) )
      assert rpcStatus.value == self.rpcStatusOK
      print( 'End resync' )
      rpcStatus = self.client.rpc_server_resync(
         EosSdkRpc_pb2.rpc_server_resync_msg( value=self.resyncEnd ) )
      assert rpcStatus.value == self.rpcStatusOK

   def createClient( self ):
      channel = grpc.insecure_channel( self.serviceAddr )
      self.client = GrpcFibService( channel )

   def initApi( self ):
      conf = EosSdkRpc_pb2.rpc_server_config_msg()
      initStatus = self.client.rpc_server_init( conf )
      assert initStatus.status.value == self.rpcStatusOK

   def reconnectClient( self ):
      def attempt():
         try:
            self.createClient()
            self.initApi()
            return True
         except grpc.RpcError:
            return False
      # Handle connection failures.
      Tac.waitFor( attempt,
                   # pylint: disable-next=consider-using-f-string
                   description=( 'grpc connection to EosSdkRpc at %s' %
                                 self.serviceAddr ) )
