#!/usr/bin/env python3
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

"""
This is top-level Python module for EthIntf Cli library. This contains methods which
are common to both Cli and CliSave Plugin.
"""

import re

#
# Returns a set of cause group names.
# For the sake of uniformity treat standalone causes also as
# cause group, with a single member with the same name
#
def getCauseGroups( causeGroupDir ):
   causeGroups = set( )

   for causeGroupName in causeGroupDir:
      causeGroups.add( causeGroupName )

   return causeGroups

#
# Errdisable causes instantiated by slice agents have sliceId 
# appended to the causeName. Eg. portgroup-disabled-FixedSystem
# This function returns the causeName without sliceId. 
#
# TODO BUG975850: remove causeNameWithoutSliceId
def causeNameWithoutSliceId( causeName ):
   if 'Linecard' in causeName:
      return re.sub( '.Linecard.*', '', causeName )
   if 'FixedSystem' in causeName:
      return re.sub( '.FixedSystem.*', '', causeName )
   if 'Switchcard' in causeName:
      return re.sub( '.Switchcard.*', '', causeName )
   if 'Mako' in causeName: # See BUG799302
      return re.sub( '.Mako.*', '', causeName )
   if 'Fabric' in causeName:
      return re.sub( '.Fabric.*', '', causeName )
   return causeName
