# Copyright (c) 2006-2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

"""
This is the top-level Python module for the EthIntf library. It contains some
constants related to frame sizes.
"""

from SysConstants.if_ether_h import ETH_FCS_LEN
from SysConstants.if_vlan_h import VLAN_ETH_HLEN
import VeosHypervisor

MAX_SUPPORTED_FRAME_SIZE = 9236

cloudPlatform = VeosHypervisor.getPlatform()
# ESXi allows max MTU of 9000 - BUG420202
if cloudPlatform == VeosHypervisor.ESXI:
   MAX_SUPPORTED_FRAME_SIZE = 9022
# DPDK based NICs support 9kB as the max frame size - BUG960021
elif cloudPlatform and cloudPlatform != VeosHypervisor.CEOSR:
   MAX_SUPPORTED_FRAME_SIZE = 9216

MAX_SUPPORTED_MTU = MAX_SUPPORTED_FRAME_SIZE - VLAN_ETH_HLEN - ETH_FCS_LEN
MAX_MGMT_MTU = 1500 # BUG5808
