#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

def doSaveEventHistory(  ehPersistentDir ):
   ehSaverConfig = Tac.newInstance( "EventHistory::ReaderConfig" )
   ehSaverConfig.dir.addMember( ehPersistentDir )
   Tac.newInstance( "EventHistory::Saver", ehSaverConfig )

def doRestoreEventHistory(  restoreDir ):
   restorerConfig = Tac.newInstance( "EventHistory::RestorerConfig" )
   restorerConfig.restoreDir = restoreDir
   restorerConfig.restoreAll = True
   restorerConfig.removeStoreFileOnRestore = True
   Tac.newInstance( "EventHistory::Restorer", restorerConfig )

def doReadEventHistory(  ehDirs, agentPattern=None, groupPattern=None ):
   ehReaderConfig = Tac.newInstance( "EventHistory::ReaderConfig" )
   ehReaderStatus = Tac.newInstance( "EventHistory::EventLog" )
   if agentPattern:
      ehReaderConfig.agentPattern = agentPattern
   if groupPattern:
      ehReaderConfig.messageGroupPattern = groupPattern
   for ehDir in ehDirs:
      ehReaderConfig.dir.addMember( ehDir )
   Tac.newInstance( "EventHistory::Reader", ehReaderConfig, ehReaderStatus )

   return ehReaderStatus

