# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=consider-using-f-string

actionKindTaccToCli = {
      'actionKindBash' : 'bash',
      'actionKindLog' : 'log' }

actionKindCliToTacc = {  v: k  for k,
                        v in actionKindTaccToCli.items() }

triggerTypeTaccToCli = {
      'onBoot' : 'on-boot',
      'onIntf' : 'on-intf',
      'onStartupConfig' : 'on-startup-config',
      'vmTracerVm' : 'vm-tracer vm',
      'onCounters' : 'on-counters',
      'onLogging' : 'on-logging',
      'onMaintenance' : 'on-maintenance',
      'onCustomCondition' : 'on-custom-condition' }

triggerTypeCliToTacc = {  v: k  for k,
                         v in triggerTypeTaccToCli.items() }
# Support for the old trigger tokens
triggerTypeCliToTacc[ 'onBoot' ] = 'onBoot'
triggerTypeCliToTacc[ 'onIntf' ] = 'onIntf'

maintenanceOperTaccToCli = {
      'maintEnter' : 'enter',
      'maintExit' : 'exit' }
maintenanceOperCliToTacc = {  v: k  for k, v in 
                             maintenanceOperTaccToCli.items() }

def getSubhandlerName( handlerName, key ):
   return f"{handlerName}({key})"

def saveDefaultBuiltinEvent( config, event ):
   name = event.handlerName
   default = config.defaultBuiltinEvent.get( name )
   if default:
      assert event == default
   config.defaultBuiltinEvent.newMember(
         name,
         event.triggerType,
         event.operstatus,
         event.ip,
         event.ip6,
         event.intfName,
         event.actionKind,
         event.command,
         event.delay,
         event.repeatInterval,
         event.maxRepeatActionCount,
         event.asynchronous,
         event.timeout,
         event.thresholdCount,
         event.threshold,
         event.pollInterval,
         event.countersCondition,
         event.logRegex,
         event.maintenanceUnitName,
         event.maintenanceOper,
         event.maintenanceStage,
         event.maintenanceBgpPeer,
         event.vrfName,
         event.metricName,
         event.runUponConfig,
         event.scriptTrigger )
   config.defaultBuiltinEvent[ name ].hasSubhandlers = event.hasSubhandlers
   config.defaultBuiltinEvent[ name ].builtinHandler = True

def builtinEventHandlerIs( config, name, params ):
   triggerTypeTacc = triggerTypeCliToTacc[ params[ 'triggerType' ] ]
   actionKindTacc = actionKindCliToTacc[ params[ 'actionKind' ] ]
   event = config.event.get( name )
   if event:
      assert event.triggerType == triggerTypeTacc and \
            event.actionKind == actionKindTacc, \
            "cannot change builtin handler %s" % name
      for key, value in params.items():
         if key in ( 'triggerType', 'actionKind', ):
            continue
         existingValue = getattr( event, key )
         assert value == existingValue, \
               f"cannot change {key} in builtin handler {name}"
      return
   if params.get( 'scriptTrigger' ) is None:
      params[ 'scriptTrigger' ] = config.defaultScriptTrigger
   event = config.event.newMember( name,
                     triggerTypeTacc,
                     params[ 'operstatus' ],
                     params[ 'ip' ],
                     params[ 'ip6' ],
                     params[ 'intfName' ],
                     actionKindTacc,
                     params[ 'command' ],
                     params[ 'delay' ],
                     params[ 'repeatInterval' ],
                     params[ 'maxRepeatActionCount' ],
                     params[ 'asynchronous' ],
                     params[ 'timeout' ],
                     params[ 'thresholdCount' ],
                     params[ 'threshold' ],
                     params[ 'pollInterval' ],
                     params[ 'countersCondition' ],
                     params[ 'logRegex' ],
                     params[ 'maintenanceUnitName' ],
                     params[ 'maintenanceOper' ],
                     params[ 'maintenanceStage' ],
                     params[ 'maintenanceBgpPeer' ],
                     params[ 'vrfName' ],
                     params[ 'metricName' ],
                     params[ 'runUponConfig' ],
                     params[ 'scriptTrigger' ] )
   event.hasSubhandlers = params[ 'hasSubhandlers' ]
   event.builtinHandler = True
   saveDefaultBuiltinEvent( config, event )
