# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
import CliMatcher

import Toggles.EventMonToggleLib as Toggle

# Dictionary of supported qt tables for cli commands.
qtEventsDict = {
   'all': 'All tables',
   'route': 'Route table',
   'route6': 'Route6 table',
   'mroute': 'Mroute table',
   'lacp': 'LACP table',
   'arp': 'ARP entries',
   'neighbor': 'Neighbor table',
   'mac': 'MAC table',
   'igmpsnooping': 'IGMP Snooping table',
   'stpunstable': 'STP Unstable table',
   'vxlanmac': 'VXLAN MAC Table',
   'nat': 'NAT table'
}

qtTableMatcher = CliCommand.Node( matcher=CliMatcher.EnumMatcher( qtEventsDict ) )

# Dictionary of all supported tables for cli commands.
allEventsDict = qtEventsDict
if Toggle.toggleNhgEventTrackingEnabled():
   allEventsDict[ 'nhg' ] = 'NHG table'

allTableMatcher = CliCommand.Node( matcher=CliMatcher.EnumMatcher( allEventsDict ) )
