#!/usr/bin/env python3
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Logging

EXTENSION_INSTALLING = Logging.LogHandle( "EXTENSION_INSTALLING",
   severity=Logging.logInfo,
   fmt="Installing extension %s, version %s, SHA-1 %s",
   explanation="EOS has started to install the extension.",
   recommendedAction=Logging.NO_ACTION_REQUIRED )

EXTENSION_INSTALLED = Logging.LogHandle( "EXTENSION_INSTALLED",
   severity=Logging.logInfo,
   fmt="Extension %s has been installed.",
   explanation="The extension has been installed.",
   recommendedAction=Logging.NO_ACTION_REQUIRED )

EXTENSION_INSTALL_ERROR = Logging.LogHandle( "EXTENSION_INSTALL_ERROR",
   severity=Logging.logError,
   fmt="Extension %s failed to install: %s",
   explanation="The extension failed to install.  The log message may contain "
               "a reason why installation failed, such as a missing "
               "dependency.",
   recommendedAction="Determine why the extension failed to install.  If a "
                     "dependency is missing, install it.  If you are unsure "
                     "how to proceed, contact the developer of the extension "
                     "or your support representative." )

EXTENSION_LOAD_ERROR = Logging.LogHandle( "EXTENSION_LOAD_ERROR",
   severity=Logging.logError,
   fmt="Extension failed to load: %s",
   explanation="The extension failed to load.  The log message or "
               "extension load log file may contain a reason why it failed, "
               "such as a broken config file.",
   recommendedAction="Determine why the extension failed to load. "
                     "If you are unsure how to proceed, contact the developer of "
                     "the extension or your support representative." )

EXTENSION_SIGNATURE_VALID = Logging.LogHandle( "EXTENSION_SIGNATURE_VALID",
   severity=Logging.logInfo,
   fmt="Extension %s has a valid signature.",
   explanation="The extension has a valid digital signature.",
   recommendedAction=Logging.NO_ACTION_REQUIRED )

EXTENSION_SIGNATURE_INVALID = Logging.LogHandle( "EXTENSION_SIGNATURE_INVALID",
   severity=Logging.logWarning,
   fmt="Extension %s has an invalid signature: %s",
   explanation="The extension has an invalid signature, or the signature"
               " could not be determined. The log message may"
               " contain a reason for the error.",
   recommendedAction="Examine the extension and determine if the contents"
                     " are correct. If the contents are not as expected,"
                     " uninstall the extension immediately. If you are unsure"
                     " how to proceed, contact the developer of the extension"
                     " or your support representative." )

EXTENSION_RESTARTING_AGENTS = Logging.LogHandle( "EXTENSION_RESTARTING_AGENTS",
   severity=Logging.logInfo,
   fmt="Extension installation finalization: restarting agents: %s",
   explanation="Agents are being restarted by operator request, in order to"
               " cause a software upgrade/patch to become effective.",
   recommendedAction=Logging.NO_ACTION_REQUIRED )

EXTENSION_UNINSTALLING = Logging.LogHandle( "EXTENSION_UNINSTALLING",
   severity=Logging.logInfo,
   fmt="Uninstalling extension %s",
   explanation="EOS has started to uninstall the extension.",
   recommendedAction=Logging.NO_ACTION_REQUIRED )

EXTENSION_UNINSTALLED = Logging.LogHandle( "EXTENSION_UNINSTALLED",
   severity=Logging.logInfo,
   fmt="Extension %s has been uninstalled.",
   explanation="The extension has been uninstalled.",
   recommendedAction=Logging.NO_ACTION_REQUIRED )

EXTENSION_UNINSTALL_ERROR = Logging.LogHandle( "EXTENSION_UNINSTALL_ERROR",
   severity=Logging.logError,
   fmt="Extension %s failed to uninstall: %s",
   explanation="The extension failed to uninstall.  The message may contain "
               "a reason why uninstallation failed, such as a dependency from "
               "another installed extension.",
   recommendedAction="Determine why the extension failed to uninstall.  Some "
                     "extensions may not support uninstall, requiring a reboot "
                     "of the switch to remove the extension.  If you are unsure "
                     "how to proceed, contact the developer of the extension or "
                     "your support representative." )

EXTENSION_STATUS_SAVE_ERROR = Logging.LogHandle( "EXTENSION_STATUS_SAVE_ERROR",
   severity=Logging.logError,
   fmt="Failed to write extension status to %s: %s",
   explanation="Cannot write extension status to the filesystem. Extension status "
              "may not be restored if Sysdb restarts.",
   recommendedAction="Check if the filesystem is full." )

PACKAGE_REPO_CREATED = Logging.LogHandle( "PACKAGE_REPO_CREATED",
   severity=Logging.logInfo,
   fmt="Package repository %s has been created.",
   explanation="The package repository has been created.",
   recommendedAction=Logging.NO_ACTION_REQUIRED )

PACKAGE_REPO_DELETED = Logging.LogHandle( "PACKAGE_REPO_DELETED",
   severity=Logging.logInfo,
   fmt="Package repository %s has been deleted.",
   explanation="The package repository has been deleted.",
   recommendedAction=Logging.NO_ACTION_REQUIRED )
