# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

'''
This module defines useful python bindings and enum aliases for the FabricIntf
package.

It should be used by tests, FRU plugins, etc... Instead of manually
declaring the TAC types/ using strings.
'''

from __future__ import absolute_import, division, print_function

import Tac
from TypeFuture import TacLazyType

Constants = Tac.Type( 'Fabric::Constants' )

IntfConfigCreator = Tac.Type( 'Fabric::IntfConfigCreator' )
InterfaceConfigAdaptor = Tac.Type( 'Fabric::InterfaceConfigAdaptor' )

FabricInterfaceStatusAggregator = Tac.Type(
   'Fabric::FabricInterfaceStatusAggregator' )
InterfaceStatusAggregator = Tac.Type(
   'Fabric::InterfaceStatusAggregator' )
EthInterfaceStatusAggregator = Tac.Type(
   'Fabric::EthInterfaceStatusAggregator' )
AllEthPhyInterfaceStatusAggregator = Tac.Type(
   'Fabric::AllEthPhyInterfaceStatusAggregator' )

FabricIntfStatusDirGenerationFilter = Tac.Type(
   'Fabric::FabricIntfStatusDirGenerationFilter' )
FabricPeerStatusGenerationFilter = Tac.Type(
   'Fabric::FabricPeerStatusGenerationFilter' )

LinkStatusWatcher = Tac.Type( 'Fabric::LinkStatusWatcher' )

FabricIntfStatusPtrConstDir = Tac.Type( 'Interface::FabricIntfStatusPtrConstDir' )

FabricIntfConfig = Tac.Type( 'Interface::FabricIntfConfig' )
FabricIntfStatus = Tac.Type( 'Interface::FabricIntfStatus' )
FabricIntfStatusDir = Tac.Type( 'Interface::FabricIntfStatusDir' )
FabricIntfConfigDir = TacLazyType( 'Interface::FabricIntfConfigDir' )
FabricPeerStatus = Tac.Type( 'Interface::FabricPeerStatus' )
FabricPeerIntfInfo = Tac.Type( 'Interface::FabricPeerIntfInfo' )

FabricConfig = Tac.Type( 'Fabric::Config' )

FabricEncap = Tac.Type( 'Interface::FabricEncap::FabricEncap' )
ENCAP_BCM_UNKNOWN = FabricEncap.unknown
ENCAP_BCM_IEEE = FabricEncap.bcmIeee
ENCAP_BCM_HIGIG2 = FabricEncap.bcmHigig2
ENCAP_BCM_CES = FabricEncap.bcmCes

EncapsulationInfo = Tac.Type( 'Fabric::EncapsulationInfo' )
InterfaceEncapsulationInfo = Tac.Type( 'Fabric::InterfaceEncapsulationInfo' )

InterfaceModeConfigPolicy = Tac.Type(
   'Fabric::InterfaceModeConfigPolicy::InterfaceModeConfigPolicy')
INTERFACE_MODE_CONFIG_POLICY_FIXED = InterfaceModeConfigPolicy.fixed
INTERFACE_MODE_CONFIG_POLICY_FP_MATCH = InterfaceModeConfigPolicy.frontPanelMatching
INTERFACE_MODE_CONFIG_POLICY_FABRIC_MATCH = InterfaceModeConfigPolicy.fabricMatching
