# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import FdlInventoryInitializer
import Tac

PtpTimeSyncConstants = Tac.Type( 'PtpTimeSync::Constants' )

class PtpTimeSyncSlaveDirInitializer( FdlInventoryInitializer.DirInitializer ):
   managedTypeName = "Inventory::PtpTimeSync::SlaveDir"
   def initInventoryEntry( self, **kwargs ):
      ptpTimeSyncSlave = self.invEntity_.newSlave( kwargs['name'] )
      ptpTimeSyncSlave.topology = kwargs['topology']
      ptpTimeSyncSlave.timeSyncDelay = kwargs['timeSyncDelay']
      ptpTimeSyncSlave.inputFreqMultiplier = kwargs['inputFreqMultiplier']
      ptpTimeSyncSlave.pllIsStandalone = \
            kwargs.get( 'pllIsStandalone', False )
      ptpTimeSyncSlave.invertFpgaSupeSel = kwargs.get( 'invertFpgaSupeSel', False )
      ptpTimeSyncSlave.internalSyncMode = kwargs.get( 'internalSyncMode',
                                                      'broadsync' )

      ptpTimeSyncSlave.phaseOffsetErrorThreshold = \
            kwargs.get( 'phaseOffsetErrorThreshold',
                        PtpTimeSyncConstants.defaultPhaseOffsetErrorThreshold )
      ptpTimeSyncSlave.reqsAlwaysOnTimeSync = \
            kwargs.get( 'reqsAlwaysOnTimeSync', False )
      ptpTimeSyncSlave.sourceClockTimestamp = kwargs.get( 'sourceClockTimestamp',
                                                          'external' )
      ptpTimeSyncSlave.supeSelectOffset = kwargs.get( 'supeSelectOffset', 0x0 )
      supeSelectMode = kwargs.get( 'supeSelectMode', 'modeDefault' )
      ptpTimeSyncSlave.gpioStatusRegisterAddress = \
            kwargs.get( 'gpioStatusRegisterAddress', 0xc080 )
      ptpTimeSyncSlave.counterInputCounterFreqInMhz = \
            kwargs.get( 'counterInputCounterFreqInMhz', 250 )

      pciFpgaName = kwargs.get( 'pciFpgaName', '' )
      cardName = kwargs.get( 'cardName', '' )

      if cardName and pciFpgaName:
         fpgaKey = Tac.newInstance( "Inventory::PtpTimeSync::FpgaKey",
                                    cardName, pciFpgaName )
      else:
         fpgaKey = Tac.newInstance( "Inventory::PtpTimeSync::FpgaKey" )

      ptpTimeSyncSlave.supeSelectInfo = \
            Tac.newInstance( 'Inventory::PtpTimeSync::SupervisorSelectInfo',
                             supeSelectMode, pciFpgaName,
                             ptpTimeSyncSlave.supeSelectOffset, fpgaKey )

      ptpTimeSyncSlave.slotId = kwargs.get( "slotId", 0 )

      return ptpTimeSyncSlave


class PtpTimeSyncMasterInitializer( FdlInventoryInitializer.Initializer ):
   managedTypeName = "Inventory::PtpTimeSync::Master"
   def initInventory( self, **kwargs ):
      self.invEntity_.block = kwargs['block']
      self.invEntity_.timeSyncVersion = kwargs['timeSyncVersion']
      self.invEntity_.delayOffset = kwargs['delayOffset']
      self.invEntity_.outputFrequency = kwargs[ 'outputFrequency' ]
      self.invEntity_.alwaysOnClock = kwargs[ 'alwaysOnClock' ]
      self.invEntity_.requiresInternalPllReset = kwargs.get(
         'requiresInternalPllReset',
         False )
      self.invEntity_.internalSyncMode = kwargs.get(
         'internalSyncMode',
         'broadsync' )
      self.invEntity_.pidControllerSupported = kwargs.get(
         'pidControllerSupported',
         True )
      self.invEntity_.standbyInputClkDisabled = kwargs.get(
         'standbyInputClkDisabled',
         False )
      self.invEntity_.counterInputCounterFreqInMhz = kwargs.get(
         'counterInputCounterFreqInMhz',
         250 )

      if self.invEntity_.requiresInternalPllReset:
         startupOps = kwargs.get( 'startupOp', [] )
         for ( opType, opAddr, opData ) in startupOps:
            op = Tac.newInstance( 'Inventory::PtpTimeSync::TimeSyncStartupOp',
                                  opType, opAddr, opData )
            self.invEntity_.startupOp.enq( op )

      return self.invEntity_

def Plugin( context ):
   context.registerInitializer( PtpTimeSyncSlaveDirInitializer )
   context.registerInitializer( PtpTimeSyncMasterInitializer )
