# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Assert
import Tac
import Toggles.XcvrToggleLib
from TypeFuture import TacLazyType
import FdlInventoryInitializer
from XcvrLib import isCmisTypeStr

LpoBwMode = TacLazyType( 'Xcvr::LpoBandwidthMode' )

class XcvrInventoryDirInitializer( FdlInventoryInitializer.DirInitializer ):
   managedTypeName = "Inventory::Xcvr::SlotDir"

   def initInventoryEntry( self, **kwargs ):
      slotType = kwargs[ 'slotType' ]
      slotId = kwargs[ 'slotId' ]
      txTraceIds = kwargs.get( 'txTraceIds', None )
      rxTraceIds = kwargs.get( 'rxTraceIds', None )

      cfp2Supported = False
      cfpxSupported = False
      cfp2DcoSupported = False
      hitfullOnSpeedChange = False
      agilePort = False
      maxBlockReadSize = 0
      maxPowerSupported = kwargs.get( 'maxPowerSupported', 0.0 )
      lpoBandwidthMode = kwargs.get( 'lpoBandwidthMode', None )

      if slotType == 'cfp2':
         cfp2Supported = kwargs[ 'cfp2Supported' ]
         cfpxSupported = kwargs[ 'cfpxSupported' ]
         cfp2DcoSupported = kwargs.get( 'cfp2DcoSupported', False )
      elif slotType == 'qsfp' or isCmisTypeStr( slotType ):
         hitfullOnSpeedChange = kwargs[ 'hitfullOnSpeedChange' ]
      elif slotType == 'sfp':
         agilePort = kwargs.get( 'agilePort', False )
         maxBlockReadSize = kwargs.get( 'maxBlockReadSize', 0 )
      else:
         assert 0, "Unhandled slotType"

      xcvrSlot = self.invEntity_.newXcvrSlot( slotId, slotType )
      capabilities = Tac.Value( "Inventory::Xcvr::XcvrSlotCapabilities" )
      capabilities.cfp2Supported = cfp2Supported
      capabilities.cfpxSupported = cfpxSupported
      capabilities.cfp2DcoSupported = cfp2DcoSupported
      capabilities.hitfullOnSpeedChange = hitfullOnSpeedChange
      capabilities.agilePort = agilePort
      capabilities.maxPowerSupported = maxPowerSupported
      capabilities.maxBlockReadSize = maxBlockReadSize
      xcvrSlot.xcvrSlotCapabilities = capabilities

      if txTraceIds and rxTraceIds:
         if slotType == 'sfp':
            numLanes = 1
         elif slotType in ( 'dsfp', 'sfpDd' ):
            numLanes = 2
         elif slotType in ( 'qsfp', 'qsfpCmis' ):
            numLanes = 4
         elif slotType in ( 'qsfpDd', 'osfp' ):
            numLanes = 8
         else:
            assert 0, "Unsupported SlotType for TraceIds"

         if ( Toggles.XcvrToggleLib.toggleXcvrLpoEnabled() and lpoBandwidthMode ):
            Assert.assertEqual( len( lpoBandwidthMode ), numLanes )

         for i in range( numLanes ):
            if ( Toggles.XcvrToggleLib.toggleXcvrLpoEnabled() and lpoBandwidthMode ):
               xcvrSlot.lpoBandwidthMode[ i ] = lpoBandwidthMode[ i ]
            xcvrSlot.txTraceId[ i ] = txTraceIds[ i ]
            xcvrSlot.rxTraceId[ i ] = rxTraceIds[ i ]

      return xcvrSlot

def Plugin( context ):
   context.registerInitializer( XcvrInventoryDirInitializer )
