# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import RoutingIntfUtils
import socket

minVirtualMacAdvInterval = 0
maxVirtualMacAdvInterval = 86400
MAX_VIRTUAL_IPS_PER_INTERFACE = 500

def intfSupportsVarp( intfName ):
   return ( not RoutingIntfUtils.isManagement( intfName ) and
            intfName.startswith( ( 'Ethernet', 'Vlan', 'Test', 'Switch' ) ) )

def vrrpMacAddr( vrId, addrFamily=socket.AF_INET, forceIpv4Mac=False ):
   if addrFamily == socket.AF_INET or forceIpv4Mac:
      return '00:00:5e:00:01:%02x' % vrId # pylint: disable=consider-using-f-string
   elif addrFamily == socket.AF_INET6:
      return '00:00:5e:00:02:%02x' % vrId # pylint: disable=consider-using-f-string
   return None

def getVrrpEncryptionKey( intfName ):
   return f'{intfName}_ietfMd5Key_VRRP'.encode()
