#!/usr/bin/env python3
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable-msg=W0232
# pylint: disable-msg=F0401
# pylint: disable-msg=E1101

# pylint: disable-next=consider-using-from-import
import FruPlugin.PmbusPowerSupply as PmbusPowerSupply
from PmbusConstants import ds2900PowerLossValues

class DS2900Driver( PmbusPowerSupply.PmbusV11Driver ):
   managedTypeName = "Inventory::PowerSupply::PowerSupplyFru"
   managedApiRe = "Astec2900"

   directM = 1
   directB = 0
   directR = 2
   tempSensorEncoding = "pmbusEncodingLinear11"
   fanCommandEncoding = "pmbusEncodingDirect11"
   readFanSpeedEncoding = "pmbusEncodingLinear11"
   inputVoltageEncoding = "pmbusEncodingLinear11"
   inputCurrentEncoding = "pmbusEncodingLinear11UnsignedMantissa"
   inputPowerEncoding = "pmbusEncodingLinear11"
   outputCurrentEncoding = "pmbusEncodingDirect11"
   outputPowerEncoding = "pmbusEncodingLinear11"
   overTempEncoding = "pmbusEncodingDirect11"
   extraDelays = False
   powerLossValues = ds2900PowerLossValues
   voltageWarningsLenient = False
   inputCurrentExponentFix = True

def Plugin( ctx ):
   ctx.registerDriver( DS2900Driver )
   
   mg = ctx.entityManager.mountGroup()
   mg.mount( 'hardware/powerSupply/pmbus11',
             'Hardware::PowerSupply::Pmbus::Config', 'w' )
   mg.close( None )
