#!/usr/bin/env python3
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable-msg=W0232
# pylint: disable-msg=F0401
# pylint: disable-msg=E1101

# pylint: disable-next=consider-using-from-import
import FruPlugin.PmbusPowerSupply as PmbusPowerSupply
from PmbusConstants import ds3000PowerLossValues
import Tac

class DS3000Driver( PmbusPowerSupply.PmbusV11Driver ):
   managedTypeName = "Inventory::PowerSupply::PowerSupplyFru"
   managedApiRe = "Emerson3000"

   directM = 1
   directB = 0
   directR = 2
   tempSensorEncoding = "pmbusEncodingLinear11"
   fanCommandEncoding = "pmbusEncodingLinear11"
   readFanSpeedEncoding = "pmbusEncodingLinear11"
   inputVoltageEncoding = "pmbusEncodingLinear11"
   inputCurrentEncoding = "pmbusEncodingLinear11"
   inputPowerEncoding = "pmbusEncodingLinear11"
   outputCurrentEncoding = "pmbusEncodingLinear11"
   outputPowerEncoding = "pmbusEncodingLinear11"
   overTempEncoding = "pmbusEncodingLinear11"
   overTempLenientDelay = 0 
   extraDelays = False
   sendByteSupported = True
   powerLossValues = ds3000PowerLossValues
   cmlFaultsLenient = True
   typeStr = "Hardware::PowerSupply::Pmbus::BlackBoxHandlerType"
   BlackBoxHandlerType = Tac.Type( typeStr )
   blackBoxHandlerType = BlackBoxHandlerType.EmersonDS3000
   pec = True

def Plugin( ctx ):
   ctx.registerDriver( DS3000Driver )

   mg = ctx.entityManager.mountGroup()
   mg.mount( 'hardware/powerSupply/pmbus11',
             'Hardware::PowerSupply::Pmbus::Config', 'w' )
   mg.close( None )
