#!/usr/bin/env python3
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable-msg=F0401
# pylint: disable-msg=W0232

# pylint: disable-next=consider-using-from-import
import FruPlugin.PmbusPowerSupply as PmbusPowerSupply
from PmbusConstants import dsPedPowerLossValues

class DSPedDriver( PmbusPowerSupply.PmbusV11Driver ):
   managedTypeName = "Inventory::PowerSupply::PowerSupplyFru"
   managedApiRe = "DSPed$"

   # m, b, and R coefficients don't matter because these supplies
   # use linear encoding for everything.
   directM = 0
   directB = 0
   directR = 0
   tempSensorEncoding = "pmbusEncodingLinear11"
   fanCommandEncoding = "pmbusEncodingLinear11"
   readFanSpeedEncoding = "pmbusEncodingLinear11"
   inputVoltageEncoding = "pmbusEncodingLinear11"
   inputCurrentEncoding = "pmbusEncodingLinear11"
   inputPowerEncoding = "pmbusEncodingLinear11"
   outputCurrentEncoding = "pmbusEncodingLinear11"
   outputPowerEncoding = "pmbusEncodingLinear11"
   overTempEncoding = "pmbusEncodingLinear11"
   outputCurrentCanSignalFailure = False
   extraDelays = False
   sendByteSupported = True
   powerLossValues = dsPedPowerLossValues

class DSPedPecDriver( DSPedDriver ):
   managedApiRe = "DSPedPec$"
   pec = True

def Plugin( ctx ):
   ctx.registerDriver( DSPedDriver )
   ctx.registerDriver( DSPedPecDriver )

   mg = ctx.entityManager.mountGroup()
   mg.mount( 'hardware/powerSupply/pmbus11',
             'Hardware::PowerSupply::Pmbus::Config', 'w' )
   mg.close( None )
