#!/usr/bin/env python3
# Copyright (c) 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Fru
import FruPlugin.Led as LedHelper
import FruPlugin.Gpio

class GpioLedDriver( Fru.FruDriver ):
   '''Fru plugin for GpioLed agent
   '''

   managedTypeName = "Inventory::GpioLed"

   requires = [ FruPlugin.Gpio.gpioInit ]

   def __init__( self, invGpioLed, parentMibEnt, parentDriver, ctx ):
      Fru.FruDriver.__init__( self, invGpioLed, parentMibEnt, parentDriver, ctx )

      fruBaseName = Fru.fruBaseName( invGpioLed )

      gpioConfigDir = ctx.sysdbRoot[ 'hardware' ][ 'gpio' ][ 'config' ][ 'led' ]

      hwGpioLedConfig = Fru.Dep( gpioConfigDir.gpioLeds, invGpioLed ).newMember(\
         invGpioLed.name )

      #Inventory::GpioPin objects have a pointer to the config object
      #This is set in the agents that setup the different gpio objects,
      #for example the Adt7462
      for pinId in invGpioLed.orange:
         pinName = invGpioLed.orange[ pinId ].systemName
         hwGpioLedConfig.gpioOrangeName[ pinName ] = True

      for pinId in invGpioLed.green:
         pinName = invGpioLed.green[ pinId ].systemName
         hwGpioLedConfig.gpioGreenName[ pinName ] = True

      for pinId in invGpioLed.yellow:
         pinName = invGpioLed.yellow[ pinId ].systemName
         hwGpioLedConfig.gpioYellowName[ pinName ] = True

      for pinId in invGpioLed.red:
         pinName = invGpioLed.red[ pinId ].systemName
         hwGpioLedConfig.gpioRedName[ pinName ] = True

      hwGpioLedConfig.ledConfig = LedHelper.addLed( invGpioLed.name,
                                                    fruBaseName, invGpioLed, ctx )
      hwGpioLedConfig.ready = True
                                              
def Plugin( ctx ):
   ctx.registerDriver( GpioLedDriver )

   mg = ctx.entityManager.mountGroup()
   mg.mount( "hardware/gpio/config/led", "Hardware::Gpio::GpioLedSystemConfigDir", 
             "w" )
   mg.close(None)
