# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

'''This module defines the FRU driver used to marshal card L1 policy configs from
the card / fixed system inventory to Sysdb hardware models.
'''

# pkgdeps: rpm Arsys-lib

import Cell
import Fru
from Fru.Driver import FruDriver
from TypeFuture import TacLazyType

CardSlotConfig = TacLazyType( 'L1::ProductCardSlotConfig' )
InvCardSlotConfig = TacLazyType( 'Inventory::L1PolicyAgent::ProductCardSlotConfig' )
MountConstants = TacLazyType( 'L1::MountConstants' )
ProductConfig = TacLazyType( 'L1::ProductConfig' )

class L1PolicyProductConfigDriver( FruDriver ):
   managedTypeName = InvCardSlotConfig.tacType.fullTypeName
   managedApiRe = '.*$'

   requires = []
   provides = [ 'L1::ProductConfig' ]

   def __init__( self, invCardSlotConfig, parentMib, parentDriver, driverCtx ):
      super().__init__( invCardSlotConfig, parentMib, parentDriver, driverCtx )

      fruBase = Fru.fruBase( invCardSlotConfig )

      cardSlotId = fruBase.sliceId
      if Cell.cellType() == 'fixed':
         cardSlotId = 'FixedSystem'

      productConfig = driverCtx.entity( MountConstants.productConfigRootDirPath() )

      slotConfig = CardSlotConfig()
      slotConfig.subdomainConfig.update( invCardSlotConfig.subdomainConfig )
      productConfig.cardSlotConfig[ cardSlotId ] = slotConfig

def Plugin( context ):
   context.registerDriver( L1PolicyProductConfigDriver )

   mg = context.entityManager.mountGroup()

   mg.mount( MountConstants.productConfigRootDirPath(),
             ProductConfig.tacType.fullTypeName,
             'w' )

   mg.close( None )
