# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Fru

class PlutoLibraryDriver( Fru.FruDriver ):
   managedTypeName = "Inventory::PlutoLibrary"
   provides = [ 'plutoLibraryInit' ]

   def __init__( self, plInv, parentMibEntity, parentDriver, driverCtx ):
      Fru.FruDriver.__init__( self, plInv, parentMibEntity, parentDriver,
                              driverCtx )
      sysdbRoot = driverCtx.sysdbRoot
      hwPlutoLibraryConfig = sysdbRoot[ 'hardware' ][ 'pluto' ][ 'library' ] \
                                      [ 'config' ]
      hwPlutoLibraryConfig.libPath = plInv.libPath
      hwPlutoLibraryConfig.devArgs = plInv.devArgs
      hwPlutoLibraryConfig.scdPresent = plInv.scdPresent

      # Set isAristaHwNoScd as true for Arista hardware where SCD is not present.
      # Currently Willamette is only such device
      # This is workaround for now. We need to revisit this when fixing BUG908442
      isAristaHwNoScd = False
      with open( '/proc/cmdline', "r" ) as cmdline:
         isAristaHwNoScd = "platform=willamette" in cmdline.read()

      hwPlutoLibraryConfig.isWhitebox = not ( plInv.scdPresent or isAristaHwNoScd )
      hwPlutoLibraryConfig.valid = True


def Plugin( context ):
   context.registerDriver( PlutoLibraryDriver )

   mg = context.entityManager.mountGroup()
   mg.mount( 'hardware/pluto/library/config',
             'Hardware::PlutoLibrary::Config', 'wi' )
   mg.close( None )
