# Copyright (c) 2008-2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import EntityMib
from EntityMib import IndexAllocator
import Fru
import FruPlugin.Gpio # pylint: disable-msg=F0401
import Tac
import Tracing

t0 = Tracing.trace0
__defaultTraceHandle__ = Tracing.Handle( "Fru.PowerController" )

ChipType = Tac.Type( 'EntityMib::Chip::ChipType' )
MAX_CHIPS_PER_SLICE = 10

class Driver( Fru.FruDriver ):
   # a gpio may be associated with the controller
   requires = [ FruPlugin.Gpio.gpioInit ]

modelsToOffsets = {
   'Ucd9012': 0,
   'Adm1266': 10,
}

def powerControllerChipId( powControllerModel, existingIds ):
   """ The generated chipId will be unique relative to all chips on the same
       linecard/cardslot. """
   t0( f'Generating chipId for powerControllerModel: {powControllerModel}, '
       f'existingIds: {list( existingIds )}.' )
   assert powControllerModel in modelsToOffsets, \
      f'invalid powControllerModel{powControllerModel}'
   
   offset = modelsToOffsets[ powControllerModel ]
   for nextLocalId in range( MAX_CHIPS_PER_SLICE ):
      chipId = IndexAllocator.getChipId( ChipType.powerController,
                                         offset + nextLocalId )
      if chipId not in existingIds:
         t0( f'Generated chipId: {chipId}' )
         return chipId
   
   raise EntityMib.MaxChipIdError \
      ( f'Max num of {powControllerModel} chipIds exceeded {MAX_CHIPS_PER_SLICE}' )
