#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
from __future__ import absolute_import, division, print_function
import Fru
import Tracing

__defaultTraceHandle__ = Tracing.Handle( "Fru.PowerDomain" )
t3 = Tracing.trace3

class PowerDomainDirDriver( Fru.FruDriver ):
   managedTypeName = "Inventory::PowerDomainDir"

   def __init__( self, invPowerDomainDir, parentMibEntity, parentDriver, driverCtx ):
      super().__init__( invPowerDomainDir, parentMibEntity, parentDriver, driverCtx )
      powerManagerConfig = \
         driverCtx.sysdbRoot.entity[ "environment/archer/power/config/powerManager" ]
      for domainName, powerDomain in invPowerDomainDir.powerDomain.items():
         powerDomainConfig = powerManagerConfig.powerDomain.get( domainName )
         t3( "Created power domain", domainName )
         if not powerDomainConfig:
            powerDomainConfig = powerManagerConfig.newPowerDomain( domainName )
         powerDomainConfig.powerSupply = powerDomain.powerSupply
         for port in powerDomain.poePort:
            powerDomainConfig.poePort.add( port )
      powerManagerConfig.ready = True

def Plugin( ctx ):
   ctx.registerDriver( PowerDomainDirDriver )
   mg = ctx.entityManager.mountGroup()
   mg.mount( "environment/archer/power/config/powerManager",
             "PowerManager::PowerManagerConfig", "w" )
   mg.close( None )
