# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Fru
import Tracing

__defaultTraceHandle__ = Tracing.Handle( "Fru.ScdFlash" )
t4 = Tracing.trace4

class ScdFlashDriver( Fru.FruDriver ):
   managedTypeName = "Inventory::Spi::ScdFlash"
   requires = [ "SpiAccelInit" ]

   def __init__( self, scdFlash, parentMibEntity, parentDriver, driverCtx ):
      t4( "ScdFlashDriver:", scdFlash )
      Fru.FruDriver.__init__( self, scdFlash, parentMibEntity, parentDriver,
                              driverCtx )

      # This Hardware::Spi::ScdFlashConfigDir is created by the SpiAccel Fru plugin.
      fruBase = Fru.fruBase( scdFlash )
      configBase = driverCtx.sysdbRoot.entity[ "hardware/spi/flash/config" ]
      if fruBase.managingCellId:
         configDir = configBase.entity[ f"cell/{fruBase.managingCellId}" ]
      else:
         configDir = configBase.entity[ f"slice/{fruBase.sliceId}" ]

      configDir.newScdFlashConfig( scdFlash.name, scdFlash.accelerator.hwSpiAccel )

def Plugin( context ):
   context.registerDriver( ScdFlashDriver )
   mg = context.entityManager.mountGroup()
   mg.mount( "hardware/spi/flash/config", "Tac::Dir", 'wi' )
   mg.close( None )
