# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, Fru, ArbusAgent

import Tracing
__defaultTraceHandle__ = Tracing.Handle( "Fru.SpiAccel" )
t4 = Tracing.trace4

class SpiAccelDriver( Fru.FruDriver ):

   managedTypeName = "Inventory::PciScd"
   primaryDriver = False
   provides = [ "SpiAccelInit" ]

   def __init__( self, scd, parentMibEntity, parentDriver, driverCtx ):
      t4( "SpiAccelDriver:", scd )
      Fru.FruDriver.__init__( self, scd, parentMibEntity, 
                              parentDriver, driverCtx )

      sysdbRoot = driverCtx.sysdbRoot

      # The Scd agent handles SCD flash and expects SCD flash config paths to exist
      # before it attempts to mount them. Therefore, we must create a SCD flash
      # config object regardless of whether it's later populated by the ScdFlash Fru
      # plugin.
      Fru.newStyleHardwareDir( sysdbRoot.entity[ 'hardware/spi/flash/config' ],
                               'Hardware::Spi::ScdFlashConfigDir', scd )

      if not scd.spiAccelBlock:
         # There's nothing more to do.
         return

      fruBaseName = Fru.fruBaseName( scd )
      agentId = ArbusAgent.sliceIdToAgentId( fruBaseName )

      hwSpi = Fru.newStyleHardwareDir( sysdbRoot[ 'hardware' ][ 'spi' ][ 'engine' ],
                                       'Hardware::Spi::Engine', scd )

      t4( "Wiring up the scd driver ham to ", scd.ham )

      for spiAccel in scd.spiAccelBlock.values():
         hwAccel = hwSpi.newAccel( spiAccel.id )
         hwAccel.ham = ( 'ham', 'hamTypeRecursive', scd.ham, spiAccel.offset, 0x30,
                         "" )
         spiAccel.hwSpiAccel = hwAccel

      hwSpi.agentId = agentId

def Plugin( context ):
   context.registerDriver( SpiAccelDriver )
   mg = context.entityManager.mountGroup()
   mg.mount( 'hardware/spi/engine', 'Tac::Dir', 'wi' )
   mg.close( None )
