#!/usr/bin/env python3
# Copyright (c) 2006-2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from FruPlugin.EthPort import EthIntfFactory, EthPortDirDriver

class VirtualEthIntfFactory( EthIntfFactory ):
   managedTypeName = "Inventory::VirtualEthPort"

class VirtualEthPortDirDriver( EthPortDirDriver ):
   managedTypeName = "Inventory::VirtualEthPortDir"
   managedApiRe = "$"

   @staticmethod
   def portLabel( port ):
      if port.subSubLabel != 0xffffffff:
         label = "%d/%d/%d" % ( port.label, # pylint: disable=consider-using-f-string
                                port.subLabel,
                                port.subSubLabel )
      elif port.subLabel != 0xffffffff:
         # pylint: disable-next=consider-using-f-string
         label = "%d/%d" % ( port.label, port.subLabel )
      else:
         label = "%d" % port.label # pylint: disable=consider-using-f-string
      return label

   def portName( self, fruEntMib, port ):
      tag = self.portNamePrefix( port )
      suffix = VirtualEthPortDirDriver.portLabel( port )
      if fruEntMib.tacType.fullTypeName == "EntityMib::Card":
         # pylint: disable-next=consider-using-f-string
         return '%s%s/%s' % ( tag, fruEntMib.relPos, suffix )
      elif fruEntMib.tacType.fullTypeName == "EntityMib::FixedSystem":
         return '%s%s' % ( tag, suffix ) # pylint: disable=consider-using-f-string
      else:
         assert 0
         return None # unreachable

def Plugin( context ):
   context.registerDriver( VirtualEthPortDirDriver )
