#!/usr/bin/env python3
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import sys, optparse
import AsuPStore
import AsuProductListGenerator

class Manifest:

   def __init__( self, out=sys.stdout ):
      self.out_ = out

   def genAsuPStoreSection( self, plugins=None, pluginPath=None ):
      self.out_.write( "# Asu PStore Feature Supported Keys\n" )
      self.out_.write( "pStoreFeatureKeysDict = " )
      supportedKeysDict = AsuPStore.getFeatureSupportedKeys( plugins, pluginPath )
      self.out_.write( str( supportedKeysDict ) )
      self.out_.write( "\n" )

   def genAsuSupportedProductSection( self ):
      self.out_.write( "# Asu Supported Products\n" )
      self.out_.write( "asuSupportedProductsList = " )
      asuSupportedProducts = AsuProductListGenerator.getAsuSupportedProductList()
      self.out_.write( str( asuSupportedProducts ) )
      self.out_.write( "\n" )

   def genManifest( self, plugins=None, pluginPath=None ):
      '''Generate manifest to out object'''
      self.genAsuPStoreSection( plugins, pluginPath )
      self.genAsuSupportedProductSection()

if __name__ == '__main__':
   op = optparse.OptionParser( usage="usage: %prog [--pythondir <path>]" )
   op.add_option( "", "--pythondir", action="append", dest="pythonDir",
                  help="directory to look for AsuPStorePlugins" )
   opts, args = op.parse_args()
   asuPluginPath = None
   if opts.pythonDir:
      asuPluginPath = [ p + "/AsuPStorePlugin" for p in opts.pythonDir ]

   man = Manifest()
   man.genManifest( pluginPath=asuPluginPath )
