# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import HttpService

class JsonApi( HttpService.HttpServiceConfig ):
   def externalServerConfig( self, vrf ):
      # pylint: disable-next=consider-using-f-string
      return """
       location ~* ^/(((openstack)/(api))|((json)/(api))) {{
          # so json api receive larger requests
          client_max_body_size 30m;

          include uwsgi_params;
          uwsgi_param  SSL_CLIENT_VERIFY  $ssl_client_verify;
          uwsgi_param  SSL_CLIENT_S_DN    $ssl_client_s_dn_legacy;
          uwsgi_param  SSL_CLIENT_SPIFFE  $ssl_client_spiffe;
          uwsgi_param  SERVER_ADDR        $server_addr;
          uwsgi_param  VRF_NAME           {vrfName};
          uwsgi_read_timeout 60m;
          uwsgi_send_timeout 60m;
          uwsgi_pass unix:///var/run/jsonapplication.uwsgi.sock;
          uwsgi_intercept_errors on;
          error_page 444 @drop;
      }}""".format( vrfName=vrf )

def Plugin( ctx ):
   ctx.registerService( JsonApi( ctx, 'JsonApi' ) )
