# Copyright (c) 2009 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

"""This module contains definitions from the IANA MAU MIB.  See
<http://www.iana.org/assignments/ianamau-mib>."""

mauTypeAUI = 1
mauType10Base5 = 2
mauTypeFoirl = 3
mauType10Base2 = 4
mauType10BaseT = 5
mauType10BaseFP = 6
mauType10BaseFB = 7
mauType10BaseFL = 8
mauType10Broad36 = 9
mauType10BaseTHD = 10
mauType10BaseTFD = 11
mauType10BaseFLHD = 12
mauType10BaseFLFD = 13
mauType100BaseT4 = 14
mauType100BaseTXHD = 15
mauType100BaseTXFD = 16
mauType100BaseFXHD = 17
mauType100BaseFXFD = 18
mauType100BaseT2HD = 19
mauType100BaseT2FD = 20
mauType1000BaseXHD = 21
mauType1000BaseXFD = 22
mauType1000BaseLXHD = 23
mauType1000BaseLXFD = 24
mauType1000BaseSXHD = 25
mauType1000BaseSXFD = 26
mauType1000BaseCXHD = 27
mauType1000BaseCXFD = 28
mauType1000BaseTHD = 29
mauType1000BaseTFD = 30
mauType10GigBaseX = 31
mauType10GigBaseLX4 = 32
mauType10GigBaseR = 33
mauType10GigBaseER = 34
mauType10GigBaseLR = 35
mauType10GigBaseSR = 36
mauType10GigBaseW = 37
mauType10GigBaseEW = 38
mauType10GigBaseLW = 39
mauType10GigBaseSW = 40
mauType10GigBaseCX4 = 41
mauType2BaseTL = 42
mauType10PassTS = 43
mauType100BaseBX10D = 44
mauType100BaseBX10U = 45
mauType100BaseLX10 = 46
mauType1000BaseBX10D = 47
mauType1000BaseBX10U = 48
mauType1000BaseLX10 = 49
mauType1000BasePX10D = 50
mauType1000BasePX10U = 51
mauType1000BasePX20D = 52
mauType1000BasePX20U = 53

mauTypeNames = {
   mauTypeAUI : 'AUI',
   mauType10Base5 : '10BASE-5',
   mauTypeFoirl : 'FOIRL',
   mauType10Base2 : '10BASE-2',
   mauType10BaseT : '10BASE-T (duplex unknown)',
   mauType10BaseFP : '10BASE-FP',
   mauType10BaseFB : '10BASE-FB',
   mauType10BaseFL : '10BASE-FL (duplex unknown)',
   mauType10Broad36 : '10BROAD-36',
   mauType10BaseTHD : '10BASE-T (half-duplex)',
   mauType10BaseTFD : '10BASE-T (full-duplex)',
   mauType10BaseFLHD : '10BASE-FL (half-duplex)',
   mauType10BaseFLFD : '10BASE-FL (full-duplex)',
   mauType100BaseT4 : '100BASE-T4',
   mauType100BaseTXHD : '100BASE-TX (half-duplex)',
   mauType100BaseTXFD : '100BASE-TX (full-duplex)',
   mauType100BaseFXHD : '100BASE-FX (half-duplex)',
   mauType100BaseFXFD : '100BASE-FX (full-duplex)',
   mauType100BaseT2HD : '100BASE-T2 (half-duplex)',
   mauType100BaseT2FD : '100BASE-T2 (full-duplex)',
   mauType1000BaseXHD : '1000BASE-X (half-duplex)',
   mauType1000BaseXFD : '1000BASE-X (full-duplex)',
   mauType1000BaseLXHD : '1000BASE-LX (half-duplex)',
   mauType1000BaseLXFD : '1000BASE-LX (full-duplex)',
   mauType1000BaseSXHD : '1000BASE-SX (half-duplex)',
   mauType1000BaseSXFD : '1000BASE-SX (full-duplex)',
   mauType1000BaseCXHD : '1000BASE-CX (half-duplex)',
   mauType1000BaseCXFD : '1000BASE-CX (full-duplex)',
   mauType1000BaseTHD : '1000BASE-T (half-duplex)',
   mauType1000BaseTFD : '1000BASE-T (full-duplex)',
   mauType10GigBaseX : '10GBASE-X',
   mauType10GigBaseLX4 : '10GBASE-LX4',
   mauType10GigBaseR : '10GBASE-R',
   mauType10GigBaseER : '10GBASE-ER',
   mauType10GigBaseLR : '10GBASE-LR',
   mauType10GigBaseSR : '10GBASE-SR',
   mauType10GigBaseW : '10GBASE-W',
   mauType10GigBaseEW : '10GBASE-EW',
   mauType10GigBaseLW : '10GBASE-LW',
   mauType10GigBaseSW : '10GBASE-SW',
   mauType10GigBaseCX4 : '10GBASE-CX4',
   mauType2BaseTL : '2BASE-TL',
   mauType10PassTS : '10PASS-TS',
   mauType100BaseBX10D : '100BASE-BX10D',
   mauType100BaseBX10U : '100BASE-BX10U',
   mauType100BaseLX10 : '100BASE-LX10',
   mauType1000BaseBX10D : '1000BASE-BX10D',
   mauType1000BaseBX10U : '1000BASE-BX10U',
   mauType1000BaseLX10 : '1000BASE-LX10',
   mauType1000BasePX10D : '1000BASE-PX10D',
   mauType1000BasePX10U : '1000BASE-PX10U',
   mauType1000BasePX20D : '1000BASE-PX20D',
   mauType1000BasePX20U : '1000BASE-PX20U',
}

