# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

SRv1001SFP = [
        0x03, 0x04, 0x07, 0x10, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x06, 0x67, 0x00, 0x00, 0x00,
        0x08, 0x03, 0x00, 0x1E, 'vn', 'vn', 'vn', 'vn',
        'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn',
        'vn', 'vn', 'vn', 'vn', 0x00, 0x00, 0x1C, 0x73,
        0x53, 0x46, 0x50, 0x2D, 0x31, 0x30, 0x47, 0x2D,
        0x53, 0x52, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x30, 0x30, 0x30, 0x31, 0x03, 0x52, 0x00, 'cc',
        0x00, 0x1a, 0x00, 0x00, 0x58, 'sn', 'sn', 'sn',
        'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn',
        0x20, 0x20, 0x20, 0x20, 'dc', 'dc', 'dc', 'dc',
        'dc', 'dc', 'dc', 'dc', 0x68, 0xf0, 0x03, 'cc',
        0x10, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xA2, 0x78,
        0xA2, 0x80, 0x00, 0x00, 'cc', 'cc', 'cc', 'cc',
]

# SRv1002SFP has both Mbase and HBase
SRv1002SFP = SRv1001SFP[ : ]
SRv1002SFP[ 118 : 124 ] = [ 0xA2, 0x78, 0xA2, 0x80, 0xA2, 0x96 ]

# SRv1003SFP has neither Mbase nor HBase
SRv1003SFP = SRv1001SFP[ : ]
SRv1003SFP[ 118 : 124 ] = [ 0xA2, 0x78, 0x00, 0x00, 0x00, 0x00 ]

# SRv1003SOLSOLREGBASESFP has neither Solregbase nor Mbase nor HBase
SRv1003NOSOLREGBASESFP = SRv1001SFP[ : ]
SRv1003NOSOLREGBASESFP[ 118 : 124 ] = [ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ]

SRv1001nondomSFP = SRv1001SFP[ : ]
SRv1001nondomSFP[ 92 ] = 0x28 # disable DOM

# Some 3rd party SFP+ AOCs do not support enhanced options
AOCSFPNoEnhOpt = SRv1001SFP[ : ]
AOCSFPNoEnhOpt[ 93 ] = 0x00

# SFP+ SRL has length < 30
SRLSFP = SRv1002SFP[ : ]
SRLSFP[ 19 ] = 0x10

# SFP+ AOC is an -SR with the active bit set
AOCSFP = SRv1002SFP[ : ]
AOCSFP[ 8 ] = 0x08
AOCSFP[ 60 : 62 ] = [ 0x0C, 0x00 ] # set cable compliance bits in wavelength field

# Some 3rd party SFP+ AOCs do not support DOM
AOCSFPNoDOM = AOCSFP[ : ]
AOCSFPNoDOM[ 92 ] = 0x00

# Create an eeprom copy of SRv1001SFP above, except with DOM
# externally calibrated.
SRv1001SFPExternal = SRv1001SFP[ : ]
# Set the diagnostic monitoring type to be externally calibrated.
# Externally calibrated: 0x58, internally calibrated: 0x68.
SRv1001SFPExternal[ 92 ] = 0x58
# Set the checksum to the appropriate value. It is 0x10 less than the
# checksum in the SRv1001SFP.
SRv1001SFPExternal[ 95 ] = int( SRv1001SFP[ 95 ], 16 ) - 0x10

SRv1001SFPBadCc = SRv1001SFP[ : ]

SRSFP25G = SRv1001SFP[ : ]
SRSFP25G[ 3 : 11 ] = [ 0x00 ] * 8 # No 10G support
SRSFP25G[ 12 ] = 0xff # 25G speed
SRSFP25G[ 14 : 18 ] = [ 0x00 ] * 4
SRSFP25G[ 18 : 20 ] = [ 0x0a, 0x07 ] # 25G SFP has length < 70m
SRSFP25G[ 36 ] = 0x02
SRSFP25G[ 44 : 46 ] = [ 0x32, 0x35 ] # SFP-25G-SR
SRSFP25G[ 66 ] = 0x67 # 25G speed

SRESFP25G = SRSFP25G[ : ]
SRESFP25G[ 50 : 52 ] = [ 0x2d, 0x45 ] # SFP-25G-SR-E (no-FEC)

XSRSFP25G = SRSFP25G[ : ]
XSRSFP25G[ 18 : 20 ] = [ 0x1e, 0x14 ] # 25G-XSR SFP has length < 300m

MRSRSFP25G = SRv1001SFP[ : ] # dual-rate 10G/25G SFP-25G-MR-SR
MRSRSFP25G[ 3 ] = 0x10  # 10GBASE-SR
MRSRSFP25G[ 4 : 11 ] = [ 0x00 ] * 7
MRSRSFP25G[ 11 ] = 0x06
MRSRSFP25G[ 12 ] = 0xff # 25G speed
MRSRSFP25G[ 13 : 18 ] = [ 0x00 ] * 5
MRSRSFP25G[ 18 : 20 ] = [ 0x1e, 0x14 ] # SFP-25G-MR-SR has length < 300m
MRSRSFP25G[ 36 ] = 0x02
MRSRSFP25G[ 44 : 54 ] = [ 0x32, 0x35, 0x47, 0x2d,
                          0x4d, 0x52, 0x2d, 0x58,
                          0x53, 0x52 ] # vendor PN SFP-25G-MR-SR
MRSRSFP25G[ 66 ] = 0x67 # 25G speed
MRSRSFP25G[ 93 ] = 0x78 # Enhanced Options
MRSRSFP25G[ 110 ] = 0x08 # Default to 25G speed

ARSFP25G = SRv1001SFP[ : ]
ARSFP25G[ 2 ] = 0x23 # no separable connector
ARSFP25G[ 3 : 11 ] = [ 0x00 ] * 8 # No infiniband compliance
ARSFP25G[ 12 ] = 0xff # 25G speed
ARSFP25G[ 14 : 18 ] = [ 0x00 ] * 4
ARSFP25G[ 18 : 20 ] = [ 0x03, 0x00 ] # 3 meter AOC
ARSFP25G[ 36 ] = 0x1
ARSFP25G[ 40 : 56 ] = [ 0x41, 0x4f, 0x43, 0x2d, 0x53,
                        0x2d, 0x53, 0x2d, 0x32, 0x35,
                        0x47, 0x2d, 0x33, 0x4d, 0x20,
                        0x20 ] # AOC-S-S-25G-3M
ARSFP25G[ 60 : 62 ] = [ 0x03, 0x52 ] # 850nm
ARSFP25G[ 66 ] = 0x67 # 25G speed

ARSFP25G3RDPTY = ARSFP25G[ : ]
ARSFP25G3RDPTY[ 8 ] = 0x8

ARNSFP25G = ARSFP25G[ : ]
ARNSFP25G[ 36 ] = 0x18

LRSFP25G = SRv1001SFP[ : ]
LRSFP25G[ 3 : 11 ] = [ 0x00 ] * 8 # No 10G support
LRSFP25G[ 12 ] = 0xff # 25G speed
LRSFP25G[ 14 : 16 ] = [ 0x0a, 0x64 ] # 25G SFP LR has length < 10km
LRSFP25G[ 16 : 20 ] = [ 0x00 ] * 4
LRSFP25G[ 36 ] = 0x03
LRSFP25G[ 44 : 46 ] = [ 0x32, 0x35 ]
LRSFP25G[ 48 : 50 ] = [ 0x4c, 0x52 ] # SFP-25G-LR
LRSFP25G[ 60 : 62 ] = [ 0x05, 0x1e ] # Wavelength 1310nm
LRSFP25G[ 64 ] = 0x2 # 1.5 W
LRSFP25G[ 66 ] = 0x67 # 25G speed

LRESFP25G = LRSFP25G[ : ]
LRESFP25G[ 50 : 52 ] = [ 0x2d, 0x45 ] # SFP-25G-LR-E (no-FEC)

LRLSFP25G = SRv1001SFP[ : ]
LRLSFP25G[ 3 : 11 ] = [ 0x00 ] * 8 # No 10G support
LRLSFP25G[ 12 ] = 0xff # 25G speed
LRLSFP25G[ 14 : 16 ] = [ 0x02, 0x14 ] # 25G SFP LR has length < 2km
LRLSFP25G[ 16 : 20 ] = [ 0x00 ] * 4
LRLSFP25G[ 36 ] = 0x03
LRLSFP25G[ 44 : 46 ] = [ 0x32, 0x35 ]
LRLSFP25G[ 48 : 51 ] = [ 0x4c, 0x52, 0x4c ] # SFP-25G-LRL
LRLSFP25G[ 60 : 62 ] = [ 0x05, 0x1e ] # Wavelength 1310nm
LRLSFP25G[ 66 ] = 0x67 # 25G speed

MRLRSFP25G = SRv1001SFP[ : ]
MRLRSFP25G[ 3 ] = 0x20 # 10GBASE-LR
MRLRSFP25G[ 4 : 11 ] = [ 0x00 ] * 7
MRLRSFP25G[ 12 ] = 0xff # 25G speed
MRLRSFP25G[ 14 : 16 ] = [ 0x0a, 0x64 ] # 25G SFP MR LR has length < 10km
MRLRSFP25G[ 16 : 20 ] = [ 0x00 ] * 4
MRLRSFP25G[ 36 ] = 0x03
MRLRSFP25G[ 44 : 54 ] = [ 0x32, 0x35, 0x47, 0x2d, 0x4d,
                          0x52, 0x2d, 0x4c, 0x52, 0x20 ] # Vendor PN SFP-25G-MR-LR
MRLRSFP25G[ 60 : 62 ] = [ 0x05, 0x1e ] # Wavelength 1310nm
MRLRSFP25G[ 66 ] = 0x67 # 25G speed
MRLRSFP25G[ 93 ] = 0x78 # Enhanced Options
MRLRSFP25G[ 110 ] = 0x08 # Default to 25G speed

ERSFP25G = SRv1001SFP[ : ]
ERSFP25G[ 3 ] = 0x00
ERSFP25G[ 12 ] = 0xff # 25G speed
ERSFP25G[ 14 : 16 ] = [ 0x28, 0xff ] # 25G SFP ER has length < 40km
ERSFP25G[ 16 : 20 ] = [ 0x00 ] * 4
ERSFP25G[ 36 ] = 0x04 # ER
ERSFP25G[ 44 : 50 ] = [ hex( ord( ch ) ) for ch in '25G-ER' ] # Vendor PN SFP-25G-ER
ERSFP25G[ 60 : 62 ] = [ 0x05, 0x1e ]  # Wavelength 1310 nm
ERSFP25G[ 66 ] = 0x67 # 25G speed
ERSFP25G[ 93 ] = 0x70 # Enhanced options - TX_DISABLE, TX_FAULT, RX_LOS

UNKNOWNSFP25G = SRSFP25G[ : ]
UNKNOWNSFP25G[ 36 ] = 0

# triple-rate 10G/25G/50G SFP-50G-MR-SR
MRSRSFP50G = SRv1001SFP[ : ]
MRSRSFP50G[ 3 ] = 0x10  # support 10G
MRSRSFP50G[ 4 : 11 ] = [ 0x00 ] * 7
MRSRSFP50G[ 11 ] = 0x08
MRSRSFP50G[ 12 ] = 0xff # support 25G
MRSRSFP50G[ 13 : 19 ] = [ 0x00 ] * 6
MRSRSFP50G[ 19 ] = 0x0A  # 50um OM3, SFP-50G-MR-SR has length < 100m
MRSRSFP50G[ 36 ] = 0x41 # 50GBASE-SR
MRSRSFP50G[ 44 : 54 ] = [ ord( ch ) for ch in
                          '50G-MR-SR ' ] # vendor PN SFP-50G-MR-SR
MRSRSFP50G[ 64 ] = 0X3C # High Power Class enable
MRSRSFP50G[ 66 ] = 0x6A
MRSRSFP50G[ 93 ] = 0xf8 # Enhanced Options
MRSRSFP50G[ 110 ] = 0x08 # Default to 50G speed

# triple-rate 10G/25G/50G SFP-50G-MR-LR
MRLRSFP50G = MRSRSFP50G[ : ]
MRLRSFP50G[ 19 ] = 0x00
MRLRSFP50G[ 36 ] = 0x45 # 50GBASE-LR
MRLRSFP50G[ 44 : 54 ] = [ ord( ch ) for ch in
                          '50G-MR-LR ' ] # vendor PN SFP-50G-MR-LR

# BX-U SFP
BXUSFP = [
   0x03, 0x04, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x01, 0x0d, 0x00, 0x0a, 0x64,
   0x00, 0x00, 0x00, 0x00, 0x4f, 0x45, 0x4d, 0x20,
   0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
   0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x90, 0x65,
   0x53, 0x46, 0x50, 0x2d, 0x42, 0x58, 0x2d, 0x55,
   0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
   0x31, 0x31, 0x2e, 0x30, 0x05, 0x1e, 0x00, 0x15,
   0x00, 0x1a, 0x00, 0x00, 0x53, 0x31, 0x33, 0x31,
   0x30, 0x30, 0x36, 0x37, 0x31, 0x36, 0x33, 0x20,
   0x20, 0x20, 0x20, 0x20, 0x31, 0x33, 0x31, 0x31,
   0x31, 0x34, 0x20, 0x20, 0x68, 0x80, 0x01, 0x5d,
   0x2d, 0x00, 0x11, 0x15, 0x82, 0x40, 0xd0, 0xf7,
   0x0d, 0xe8, 0xea, 0x13, 0x54, 0x45, 0x19, 0x1f,
   0xe2, 0x14, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x61, 0xb7, 0xbb, 0x7f
]

# BX-D SFP
BXDSFP = BXUSFP[ : ]
BXDSFP[ 60 : 62 ] = [ 0x05, 0xD2 ]

LRv1001SFP = SRv1001SFP[ : ]
LRv1001SFP[ 3 ] = 0x20
LRv1001SFP[ 14 ] = 0x10
LRv1001SFP[ 40 ] = 'S'
LRv1001SFP[ 41 ] = 'F'
LRv1001SFP[ 42 ] = 'P'
LRv1001SFP[ 43 ] = '-'
LRv1001SFP[ 44 ] = '1'
LRv1001SFP[ 45 ] = '0'
LRv1001SFP[ 46 ] = 'G'
LRv1001SFP[ 47 ] = '-'
LRv1001SFP[ 48 ] = 'L'
LRv1001SFP[ 49 ] = 'R'
LRv1001SFP[ 50 ] = ' '
LRv1001SFP[ 51 ] = ' '
LRv1001SFP[ 60 ] = 0x05
LRv1001SFP[ 61 ] = 0x1E

# LRL has length less than 10
LRLSFP = LRv1001SFP[ : ]
LRLSFP[ 14 ] = 0x05

# ER has length less than 40
ERSFP = LRv1001SFP[ : ]
ERSFP[ 3 ] = 0x80
ERSFP[ 14 ] = 0x24

# ERBDU ( BiDi upstream ) has transmit wavelength of 1270nm
ERBDUSFP = ERSFP[ : ]
ERBDUSFP[ 60 ] = 0x04
ERBDUSFP[ 61 ] = 0xF6
# ERBDD ( BiDi Downstream ) has transmit wavelength of 1330nm
ERBDDSFP = ERSFP[ : ]
ERBDDSFP[ 60 ] = 0x05
ERBDDSFP[ 61 ] = 0x32

# ERL's have length less than 30
ERLSFP = LRv1001SFP[ : ]
ERLSFP[ 3 ] = 0x80
ERLSFP[ 14 ] = 0x1D

# ERBDU ( BiDi upstream ) has transmit wavelength of 1270nm
ERLBDUSFP = ERLSFP[ : ]
ERLBDUSFP[ 60 ] = 0x04
ERLBDUSFP[ 61 ] = 0xF6
# ERBDD ( BiDi Downstream ) has transmit wavelength of 1330nm
ERLBDDSFP = ERLSFP[ : ]
ERLBDDSFP[ 60 ] = 0x05
ERLBDDSFP[ 61 ] = 0x32

# ZR has length over 40
ZRSFP = ERSFP[ : ]
ZRSFP[ 14 ] = 0x30

LRMv1001SFP = SRv1001SFP[ : ]
LRMv1001SFP[ 3 ] = 0x40
LRMv1001SFP[ 40 ] = 'S'
LRMv1001SFP[ 41 ] = 'F'
LRMv1001SFP[ 42 ] = 'P'
LRMv1001SFP[ 43 ] = '-'
LRMv1001SFP[ 44 ] = '1'
LRMv1001SFP[ 45 ] = '0'
LRMv1001SFP[ 46 ] = 'G'
LRMv1001SFP[ 47 ] = '-'
LRMv1001SFP[ 48 ] = 'L'
LRMv1001SFP[ 49 ] = 'R'
LRMv1001SFP[ 50 ] = 'M'
LRMv1001SFP[ 51 ] = ' '
LRMv1001SFP[ 60 ] = 0x05
LRMv1001SFP[ 61 ] = 0x1E

CRSFP = SRv1001SFP[ : ]
CRSFP[ 3 ] = 0x1
CRSFP[ 40 ] = 'S'
CRSFP[ 41 ] = 'F'
CRSFP[ 42 ] = 'P'
CRSFP[ 43 ] = '-'
CRSFP[ 44 ] = '1'
CRSFP[ 45 ] = '0'
CRSFP[ 46 ] = 'G'
CRSFP[ 47 ] = '-'
CRSFP[ 48 ] = 'C'
CRSFP[ 49 ] = 'R'
CRSFP[ 50 ] = ' '
CRSFP[ 51 ] = ' '

# Enhanced options and DOM unsupported for passive copper modules
CRSFP[ 92 ] = 0x00
CRSFP[ 93 ] = 0x00

# Note that the only difference between CRSFP and CRSFPP is that
# CRSFPP explicitly has the passive bit (8.2) set, but CRSFP doesnt
# and is considered passive by default

CRSFPP = CRSFP[ : ]
CRSFPP[ 8 ] = 0x4

CRSFPA = CRSFP[ : ]
CRSFPA[ 8 ] = 0x8

LXv1001SFP = SRv1001SFP[ : ]
LXv1001SFP[ 3 ] = 0x00
LXv1001SFP[ 4 ] = 0x00
LXv1001SFP[ 5 ] = 0x00
LXv1001SFP[ 6 ] = 0x02
LXv1001SFP[ 11 ] = 0x01
LXv1001SFP[ 12 ] = 0x0C
LXv1001SFP[ 14 ] = 0x0A
LXv1001SFP[ 15 ] = 0x64
LXv1001SFP[ 16 ] = 0x37
LXv1001SFP[ 17 ] = 0x37
LXv1001SFP[ 19 ] = 0x00
LXv1001SFP[ 40 ] = 'S'
LXv1001SFP[ 41 ] = 'F'
LXv1001SFP[ 42 ] = 'P'
LXv1001SFP[ 43 ] = '-'
LXv1001SFP[ 44 ] = '1'
LXv1001SFP[ 45 ] = 'G'
LXv1001SFP[ 46 ] = '-'
LXv1001SFP[ 47 ] = 'L'
LXv1001SFP[ 48 ] = 'X'
LXv1001SFP[ 49 ] = ' '
LXv1001SFP[ 50 ] = ' '
LXv1001SFP[ 51 ] = ' '
# XXX_LWR: This is incomplete -- wavelength, etc., aren't overridden from SR

SXSFP = LXv1001SFP[ : ]
SXSFP[ 6 ] = 1

LX10SFP = LXv1001SFP[ : ]
LX10SFP[ 6 ] = 0x10

LX10GRA1GSFP = LXv1001SFP[ : ]
LX10GRA1GSFP[ 11 ] = 0x06
LX10GRA1GSFP[ 12 ] = 0x67
LX10GRA1GSFP[ 16 ] = 0x00
LX10GRA1GSFP[ 17 ] = 0x00
LX10GRA1GSFP[ 40 : 56 ] = [ ord( a ) for a in 'SFP-10G-RA-1G-LX' ]

LXv1001nondomSFP = LXv1001SFP[ : ]
LXv1001nondomSFP[ 92 ] = 0x28 # disable DOM

# Third-party dual-speed 1G/10G SFPs
SRDualSpeed = SRv1001SFP[ : ]
SRDualSpeed[ 6 ] = 0x01 # Add 1000BASE-SX support

LRDualSpeed = LRv1001SFP[ : ]
LRDualSpeed[ 6 ] = 0x02 # Add 1000BASE-LX support

# XXX_RMO Adding this case to test the important part of the HP Twin Ax cable.
# For now, this is only used in test test/t001.py just to make sure we continue
# to support HP TwinAx.
HPTwinAx = SRv1001SFP[ : ]
HPTwinAx[ 3 ] = 0x81

# XXX_RMO Adding this for testing DWDM optics. Only changing the fields that
# enable us to detect the DWDM optic and report wavelength.
SFPDWDM = SRv1001SFP[ : ]
SFPDWDM[ 0 ] = 0x0B
SFPDWDM[ 1 ] = 0x24
SFPDWDM[ 3 ] = 0x80
SFPDWDM[ 13 ] = 0x00
SFPDWDM[ 14 ] = 0x28
SFPDWDM[ 60 ] = 0x06
SFPDWDM[ 61 ] = 0x13
SFPDWDM[ 62 ] = 0x09

# XXX_RMO Adding the new case for ZR which differ from ER by one field.
SFPDWDMZR = SFPDWDM[ : ]
SFPDWDMZR[ 14 ] = 0x50

SFPDWDMZT = SRv1001SFP[ : ]
SFPDWDMZT[ 0 ] = 0x0B
SFPDWDMZT[ 1 ] = 0x04
SFPDWDMZT[ 3 ] = 0x80
SFPDWDMZT[ 13 ] = 0x00
SFPDWDMZT[ 14 ] = 0x50
# The wavelength field (byte 60-61) is not supported for tunable SFP+.
SFPDWDMZT[ 60 ] = 0x00
SFPDWDMZT[ 61 ] = 0x00
SFPDWDMZT[ 62 ] = 0x00
SFPDWDMZT[ 65 ] = 0x5A

CRSFP25G = CRSFP[ : ]
CRSFP25G[ 12 ] = 0xff
CRSFP25G[ 36 ] = 0x0B
CRSFP25G[ 44 ] = '2'
CRSFP25G[ 45 ] = '5'
CRSFP25G[ 66 ] = 0x67

CRSSFP25G = CRSFP25G[ : ]
CRSSFP25G[ 36 ] = 0x0C

CRNSFP25G = CRSFP25G[ : ]
CRNSFP25G[ 36 ] = 0x0D

CRSFP50G = CRSFP25G[ : ]
CRSFP50G[ 36 ] = 0x40

# Note that the only difference between CRSFP25G and CRSFPP25G is that
# CRSFPP25G explicitly has the passive bit (8.2) set, but CRSFP25G doesnt
# and is considered passive by default

CRSFPP25G = CRSFP25G[ : ]
CRSFPP25G[ 8 ] = 0x4 # Passive copper
CRSFPP25G[ 36 ] = 0xff # Extended compliance to invalid value

CRSFPP50G = CRSFP50G[ : ]
CRSFPP50G[ 8 ] = 0x4 # Passive copper
CRSFPP50G[ 36 ] = 0xff # Extended compliance to invalid value
CRSFPP50G[ 66 ] = 0xCE # BR max to > 200

# 1000BASE-T
Tv2SFP = [
   0x03, 0x04, 0x22, 0x00, 0x00, 0x00, 0x08, 0x00,
   0x00, 0x00, 0x00, 0x01, 0x0C, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x64, 0x00, 0x41, 0x72, 0x69, 0x73,
   0x74, 0x61, 0x20, 0x4E, 0x65, 0x74, 0x77, 0x6F,
   0x72, 0x6B, 0x73, 0x20, 0x00, 0x00, 0x1C, 0x73,
   0x53, 0x46, 0x50, 0x2D, 0x31, 0x47, 0x2D, 0x54,
   0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
   0x30, 0x30, 0x30, 0x32, 0x00, 0x00, 0x00, 'cc',
   'ms', 0X02, 0x00, 0x00, 0x58, 'sn', 'sn', 'sn',
   'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn',
   0x20, 0x20, 0x20, 0x20, 'dc', 'dc', 'dc', 'dc',
   'dc', 'dc', 'dc', 'dc', 0x00, 'ms', 0x00, 'cc',
   0x01, 'aa', 'cs', 'cs', 'cs', 'cs', 'cs', 'cs',
   'cs', 'cs', 'cs', 'cs', 'cs', 'cs', 'cs', 'cs',
   'cs', 'cs', 'cs', 'cs', 'cs', 'cs', 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 'cr', 'cr', 'cr', 'cr',
]

# 3rd party 1000Base-T SFP may have non-zero extended compliance code
TSFP3RDPTY = [
   0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
   0x00, 0x00, 0x00, 0x01, 0x0D, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x64, 0x00, 0x41, 0x72, 0x69, 0x73,
   0x74, 0x61, 0x20, 0x4E, 0x65, 0x74, 0x77, 0x6F,
   0x72, 0x6B, 0x73, 0x20, 0x01, 0x00, 0x1C, 0x73,
   0x53, 0x46, 0x50, 0x2D, 0x31, 0x47, 0x2D, 0x54,
   0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
   0x30, 0x30, 0x30, 0x32, 0x41, 0x0C, 0xC1, 'cc',
   0x00, 0x01, 0x00, 0x00, 0x58, 'sn', 'sn', 'sn',
   'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn',
   0x20, 0x20, 0x20, 0x20, 'dc', 'dc', 'dc', 'dc',
   'dc', 'dc', 'dc', 'dc', 0x00, 0x00, 0x00, 'cc',
   0x01, 'aa', 'cs', 'cs', 'cs', 'cs', 'cs', 'cs',
   'cs', 'cs', 'cs', 'cs', 'cs', 'cs', 'cs', 'cs',
   'cs', 'cs', 'cs', 'cs', 'cs', 'cs', 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 'cr', 'cr', 'cr', 'cr',
]

TSFP10G = [
   0x03, 0x04, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x06, 0x67, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x1e, 0x00, 0x41, 0x72, 0x69, 0x73,
   0x74, 0x61, 0x20, 0x4e, 0x65, 0x74, 0x77, 0x6f,
   0x72, 0x6b, 0x73, 0x20, 0x16, 0x00, 0x1c, 0x73,
   0x53, 0x46, 0x50, 0x2d, 0x31, 0x30, 0x47, 0x2d,
   0x54, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
   0x30, 0x30, 0x30, 0x31, 0x00, 0x00, 0x00, 0x00,
   0x20, 0x12, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

# SFP-10G-MRA-T
TSFP10GMRA = TSFP10G[ : ]
TSFP10GMRA[ 11 ] = 0x00
TSFP10GMRA[ 48 ] = ord( 'M' )
TSFP10GMRA[ 49 ] = ord( 'R' )
TSFP10GMRA[ 50 ] = ord( 'A' )
TSFP10GMRA[ 51 ] = ord( '-' )
TSFP10GMRA[ 52 ] = ord( 'T' )
TSFP10GMRA[ 64 ] = 0x20
TSFP10GMRA[ 65 ] = 0x00
TSFP10GMRA[ 112 ] = 0x1  # ProgID
# Enhanced options
TSFP10GMRA[ 93 ] = 0x40  # Set soft TX disable implemented (bit 6) to 1

# SFP-10G-T-RP
TSFP10GRP = TSFP10G[ : ]
TSFP10GRP[ 49 ] = ord( '-' )
TSFP10GRP[ 50 ] = ord( 'R' )
TSFP10GRP[ 51 ] = ord( 'P' )
TSFP10GRP[ 64 ] = 0x02 # Declare power level 2
TSFP10GRP[ 65 ] = 0x12 # RXLOS and RATE_SELECT implemented
TSFP10GRP[ 92 ] = 0x60 # Internally calibrated DOM implemented

AQS107_TSFP10GSR = [
   0x03, 0x04, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x1e, 0x00, 0x41, 0x51, 0x55, 0x41,
   0x44, 0x54, 0x49, 0x41, 0x20, 0x20, 0x20, 0x20,
   0x20, 0x20, 0x20, 0x20, 0x1c, 0x00, 0x17, 0xb6,
   0x41, 0x51, 0x53, 0x2d, 0x31, 0x30, 0x37, 0x2d,
   0x43, 0x58, 0x2d, 0x31, 0x20, 0x20, 0x20, 0x20,
   0x30, 0x31, 0x20, 0x20, 0x00, 0x00, 0x00, 0xd9,
   0x28, 0x00, 0x00, 0x00, 0x31, 0x39, 0x32, 0x30,
   0x30, 0x30, 0x30, 0x36, 0x32, 0x32, 0x20, 0x20,
   0x20, 0x20, 0x20, 0x20, 0x31, 0x39, 0x30, 0x35,
   0x31, 0x33, 0x20, 0x20, 0x00, 0x70, 0x00, 0xc1,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

Molex_74765_0902 = [
   0x03, 0x04, 0x80, 0x01, 0x00, 0x00, 0x04, 0x41,
   0x84, 0x80, 0xd5, 0x00, 0x78, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x4d, 0x6f, 0x6c, 0x65,
   0x78, 0x20, 0x49, 0x6e, 0x63, 0x2e, 0x20, 0x20,
   0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x09, 0x3a,
   0x37, 0x34, 0x37, 0x36, 0x35, 0x2d, 0x30, 0x39,
   0x30, 0x32, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
   0x41, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 'cc',
   'ms', 'ms', 0x00, 0x00, 0x38, 'sn', 'sn', 'sn',
   'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn',
   0x20, 0x20, 0x20, 0x20, 'dc', 'dc', 'dc', 'dc',
   'dc', 'dc', 'dc', 'dc', 0x00, 'ms', 0x00, 'cc',
   0x00, 'aa', 'cs', 'cs', 'cs', 'cs', 'cs', 'cs',
   'cs', 'cs', 'cs', 'cs', 'cs', 'cs', 'cs', 'cs',
   'cs', 'cs', 'cs', 'cs', 'cs', 'cs', 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 'cr', 'cr', 'cr', 'cr',
]

# Taken from AXIOM MEMORY AXG95665 module
FXSFP = [
   0x03, 0x04, 0x07, 0x00, 0x00, 0x00, 0x20, 0x00,
   0x00, 0x00, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00,
   0xc8, 0xc8, 0x00, 0x00, 'vn', 'vn', 'vn', 'vn',
   'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn',
   'vn', 'vn', 'vn', 'vn', 0x00, 0x00, 0x0a, 0x1d,
   0x41, 0x58, 0x47, 0x39, 0x35, 0x36, 0x36, 0x35,
   0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
   0x30, 0x30, 0x30, 0x30, 0x05, 0x1e, 0x00, 'cc',
   0x00, 0x12, 0x00, 0x00, 0x41, 0x58, 0x47, 0x45,
   0x4e, 0x46, 0x58, 0x30, 0x30, 0x30, 0x32, 0x35,
   0x20, 0x20, 0x20, 0x20, 0x31, 0x35, 0x31, 0x30,
   0x33, 0x30, 0x20, 0x20, 0x00, 0x00, 0x00, 'cc',
   0x2b, 0x00, 0x11, 0x71, 0xb3, 0x58, 0x9a, 0x25,
   0xff, 0x43, 0x8b, 0x8c, 0x97, 0xc7, 0xe2, 0x03,
   0xd4, 0x63, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 'crc', 'crc', 'crc', 'crc',
]

# WNC SFP loopback
WncLoopbackSfp = [
   0x57, 0x4e, 0x43, 0x20, 0x32, 0x57, 0x20, 0x32,
   0x35, 0x47, 0x20, 0x53, 0x46, 0x50, 0x32, 0x38,
   0x20, 0x4c, 0x4f, 0x4f, 0x50, 0x42, 0x41, 0x43,
   0x4b, 0x20, 0x4d, 0x4f, 0x44, 0x55, 0x4c, 0x45,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0x32, 0x30, 0x31, 0x39, 0x31, 0x30, 0x31, 0x36,
   0x33, 0x30, 0x38, 0x34, 0x36, 0x35, 0x35, 0x33,
   0x38, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
]
