#!/usr/bin/env python3
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

"""
This module contains the common helper methods for IgmpSnooping.
"""

def isVlanActive( bridgingInputCli, vlanId ):
   """Check if the vlan is configured and active.
      bridgingInputCli points to bridging/input/config/cli in sysdb"""
   vlan = bridgingInputCli.vlanConfig.get( vlanId )
   return vlan and vlan.adminState == 'active'

def activeVlans( bridgingInputCli, protocolStatus=None ):
   """Returns a set of all configured and active vlans.
      bridgingInputCli points to bridging/input/config/cli in sysdb"""
   vlans = bridgingInputCli.vlanConfig
   vlanIds = { v for v in vlans if isVlanActive( bridgingInputCli, v ) }
   if protocolStatus:
      vlanIds.update( protocolStatus.contextStatus )
   return vlanIds

def agentName():
   ''' Returns the agent name. Call this if and only if the intention
   is to run the agent locally. The call enables the static analyzer
   to generate the correct RPM dependencies. '''
   return 'IgmpSnooping'
