#!/usr/bin/env python3
# Copyright (c) 2008-2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, Agent, Tracing, QuickTrace, os

__defaultTraceHandle__ = Tracing.Handle( "IgmpSnooping" )
t0 = Tracing.trace0
t3 = Tracing.trace3
t8 = Tracing.trace8
t6 = Tracing.trace6

Tac.activityManager.useEpoll = True

class IgmpSnooping ( Agent.Agent ):
   """ The IGMP Snooping Stub Agent. 
   Used only in Abuild environment. Not used in stest, ptest, or production. """

   def __init__( self, entityManager, _agentName=None, blocking=False ):
      
      Agent.Agent.__init__( self, entityManager, _agentName )
      # pylint: disable-next=consider-using-f-string
      qtfile = "%s%s.qt" % ( self.agentName, "-%d" if "QUICKTRACEDIR"
                             not in os.environ else "" )
      QuickTrace.initialize( qtfile, "32,32,32,32,32,32,32,32,32,32" )
      print( "IgmpSnoopingStubAgent started" )

   def doInit( self, entityManager ):
      mountGroup = entityManager.mountGroup()

      def _finish():
         t0( "Mounts complete." )

      mountGroup.close( _finish )

   def initForActive( self ):
      pass
