# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

'''This module defines card interface slot range matchers.

Interface slots are an L1 concept which points to a grouping of interdependent
interfaces on the switch. For L1 Profiles, rather than match on a particular card (
e.g. Ethernet2 on Linecard6 ), we want to match the interface slot on any possible
card ( e.g. Ethernet2 ). Thus do not know in advance what interfaces are possible and
need a new matcher.

TODO:
   BUG716924: Add a plugin system so that the matcher can support multiple interface
              slot prefixes ( e.g. Switch, CPU, App, etc... )
'''

from Intf.IntfRange import (
   GenericRangeIntfType,
   IntfRangeMatcher
)

EthernetIntfSlotType = GenericRangeIntfType(
   lambda: ( 1, 102 ),
   'Ethernet',
   'Et',
   'Hardware Ethernet Interface Slots',
   lazyRange=True )

AllIntfSlotTypes = { 'Ethernet': EthernetIntfSlotType }

CardIntfSlotRangeMatcher = IntfRangeMatcher(
   explicitIntfTypes=list( AllIntfSlotTypes.values() ),
   matchWildcards=False )
