# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import itertools

import CliSession
import Intf.IntfRange as IntfRange
import LazyMount

hwCapabilities = None
_em = None
internalRecircIntfConfigDir = None

class InternalRecircIntf( IntfRange.AutoIntfType ):
   def __init__( self ):
      IntfRange.AutoIntfType.__init__( self, "InternalRecirc", "Ir",
                                       "Internal recirculation interface" )

   def collection( self ):
      mergedConfig = [ iter( hwCapabilities.availablePort ),
                       iter( internalRecircIntfConfigDir.intfConfig ) ]
      return itertools.chain.from_iterable( mergedConfig )

   def collectionVersion( self ):
      return [ hwCapabilities.portVersion,
               internalRecircIntfConfigDir.intfConfig.version() ]

   def collectionSessionName( self ):
      return CliSession.currentSession( _em )

InternalRecircAutoIntfType = InternalRecircIntf()

intfOptions = IntfRange.IntfOptions( ipSupport=False, routingProtoSupport=False )
IntfRange.registerIntfType( InternalRecircAutoIntfType, intfOptions )

def configuredInternalRecircIntfCallback( requireMounts, explicitIntfTypes ):
   if explicitIntfTypes and 'InternalRecirc' not in explicitIntfTypes:
      return []
   return requireMounts.getValue( 'interface/config/recirc' ).intfConfig

IntfRange.registerConfiguredIntfCallback( configuredInternalRecircIntfCallback )

def Plugin( entityManager ):
   global hwCapabilities
   global internalRecircIntfConfigDir
   global _em
   hwCapabilities = LazyMount.mount( entityManager,
                                     "hardware/internalport/hwcapabilities",
                                     "Arnet::InternalRecircIntfHwCapabilities", "r" )
   _em = entityManager
   internalRecircIntfConfigDir = LazyMount.mount( entityManager,
                                     "interface/config/recirc",
                                     "Interface::InternalRecircIntfConfigDir", "r" )
