#!/usr/bin/env python3
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from LoopbackIntfUtils import minLoopbackIntfNum
from LoopbackIntfUtils import maxLoopbackIntfNum
import Intf.IntfRange as IntfRange

LoopbackAutoIntfType = IntfRange.GenericRangeIntfType(
   lambda: ( minLoopbackIntfNum, maxLoopbackIntfNum ),
   "Loopback", "Lo", "Loopback interface", lazyRange=True )

intfOptions = IntfRange.IntfOptions( ipSupport=True, routingProtoSupport=True )
IntfRange.registerIntfType( LoopbackAutoIntfType, intfOptions )
