# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

'''This module defines the module range matcher implementation.

This file should not be explicitly imported and only exists so that the CLI / CLI
Save infrastructure can automatically load it, execute the mounts, and ultimately
register the implementation with the rest of the module range matching
infrastructure.
'''

from __future__ import absolute_import, division, print_function

from Fru import (
   CliUtilities,
   ModuleRange
)
from MultiRangeRule import GenericRangeType
import CliGlobal

gv = CliGlobal.CliGlobal( dict( entityMib=None, ) )

class ModuleRangeType( GenericRangeType ):
   def moduleRange( self, mode ):
      return CliUtilities.rangeFn( gv.entityMib.root, self.tagLong )

   def __init__( self, moduleType ):
      super( ModuleRangeType, self ).__init__( # pylint: disable=super-with-arguments
         rangeFn=self.moduleRange,
         # pylint: disable-next=consider-using-f-string
         helpdesc='{} modules'.format( moduleType ),
         tagLong=moduleType,
         dynamicRange=True )

# Why reinvent the wheel? The list of currently supported module types already
# exists in the expression generator class.
for modType in CliUtilities.moduleTypes:
   ModuleRange.registerModuleRangeType( ModuleRangeType( modType ) )

def Plugin( em ):
   mg = em.mountGroup()
   gv.entityMib = mg.mount( 'hardware/entmib', 'EntityMib::Status', 'r' )
   mg.close( None )
