# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import Intf.IntfRange as IntfRange # pylint: disable=consider-using-from-import

PortChannelNum = Tac.Type( "Lag::PortChannelNum" )

RecircAutoIntfType = IntfRange.GenericRangeIntfType(
   lambda mode: ( PortChannelNum.min, PortChannelNum.max ),
   "Recirc-Channel", "Re", "Recirculation interface",
   subSupported=True, subIntfGuard=IntfRange.subintfSupportedGuard )

intfOptions = IntfRange.IntfOptions( ipSupport=False, routingProtoSupport=False )
IntfRange.registerIntfType( RecircAutoIntfType, intfOptions )
