#!/usr/bin/env python3
# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Intf.IntfRange as IntfRange # pylint: disable=consider-using-from-import

# Subinterface has no specific interface type, but we need to register a
# configuredIntfCallback as subintf has its own config mount points.
def configuredSubIntfCallback( requireMounts, explicitIntfTypes ):
   intfs = requireMounts.getValue( 'interface/config/subintf' ).intfConfig
   return filter(
      lambda x: any( x.startswith( t ) for t in explicitIntfTypes ),
      intfs )

IntfRange.registerConfiguredSubIntfCallback( configuredSubIntfCallback )
