# Copyright (c) 2006-2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Intf.IntfRange as IntfRange # pylint: disable=consider-using-from-import
import Tac

hwCapabilities = None

VlanAutoIntfType = IntfRange.GenericRangeIntfType(
   lambda: ( Tac.Type( 'Bridging::VlanId' ).min,
      hwCapabilities.maxExtendedVlanId or Tac.Type( 'Bridging::VlanId' ).max ),
   "Vlan", "Vl", "VLAN interface",
   lazyRange=True )
intfOptions = IntfRange.IntfOptions( ipSupport=True, routingProtoSupport=True )
IntfRange.registerIntfType( VlanAutoIntfType, intfOptions )

def Plugin( entityManager ):
   global hwCapabilities
   mg = entityManager.mountGroup()
   hwCapabilities = mg.mount( 'bridging/hwcapabilities',
                              'Bridging::HwCapabilities', 'r' )
   mg.close( callback=None, blocking=False )
