# Copyright (c) 2009-2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from collections import namedtuple
from IpLibTypes import VrfNameType, IpAddrScopeType
from Tac import enumValue

MAX_SECONDARIES_PER_INTERFACE = 500

DEFAULT_VRF = VrfNameType.defaultVrf
DEFAULT_VRF_OLD = 'main'
# When used as VRF name it implies 'every configured vrf'
ALL_VRF_NAME = 'all'

VRFNAMES_RESERVED = [ DEFAULT_VRF, DEFAULT_VRF_OLD, ALL_VRF_NAME ]

# Create a namedtuple version of the Ip::IpAddrScope Tac::Enum
IpAddrScope = namedtuple( 'IpAddrScope', list( IpAddrScopeType.attributes ) )(
      *[ enumValue( IpAddrScopeType.tacType.fullTypeName, valueName )
         for valueName in list( IpAddrScopeType.attributes ) ] )
