# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from TypeFuture import TacLazyType
from Tac import Type
import Tac

VrfNameType = TacLazyType( 'L3::VrfName' )
ProtocolAgentModelType = TacLazyType( 'L3::ProtocolAgentModelType' )
IpAddrScopeType = TacLazyType( 'Ip::IpAddrScope' )

# pylint: disable-msg=inconsistent-return-statements
def addrSource( af ):
   if af == Type( "Arnet::AddressFamily" ).ipv4:
      return Type( "Ip::AddrSource" )
   if af == Type( "Arnet::AddressFamily" ).ipv6:
      return Type( "Ip6::AddrSource" )
   assert 0, 'Invalid af'

def tacRouteDistinguisherWithPrecedence( rd, precedence ):
   return Tac.newInstance( "Ip::RouteDistinguisherWithPrecedence", rd, precedence )

def vrfNameSortKey( vrfName ):
   # keep default at the beginning
   return '' if vrfName == VrfNameType.defaultVrf else vrfName
