#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
from TypeFuture import TacLazyType

ipTablesChainTypeIndrInstance = TacLazyType( "Acl::IptablesChainTypeIndirection" )
ruleRenderFn = TacLazyType( "IptablesHelper::RuleRenderer" )
getIpTblChainTypeInstance = TacLazyType( "Acl::PluginContext" )
eosConstants = TacLazyType( "IptablesHelper::EosConstants" )

def getChainTypeByName( chainName ):
   return getIpTblChainTypeInstance.getChainTypeByName( chainName )
 
# Ex: use as getChainType('input') in the test to get the IptableschainType enum
def getChainType( methodName ):
   if hasattr( ipTablesChainTypeIndrInstance, methodName ):
      fn = getattr( ipTablesChainTypeIndrInstance, methodName )
      return fn()
   else:
      assert False, f"Method {methodName} not found"

def RT( template ):
   return ruleRenderFn.renderTemplate( template )
