# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from contextlib import contextmanager
import os
import subprocess

@contextmanager
def networkRequired():
   # We have to be inside a network namespace created by "isolate -i"
   # to run dhclient.  Otherwise, we assume that the infrastructure
   # has already gotten us an address.
   dev = os.environ.get( 'NS_INTERFACE' )
   if dev:
      # dhclient invocation copied from A4.chrootLib
      cmd = [ 'sudo', 'dhclient', dev, '-pf', '/dev/null',
              '-lf', '/dev/null',
              '-sf', '/usr/share/Artools/dhclient-script' ]
      subprocess.check_call( cmd )
   yield
   if dev:
      cmd = [ 'sudo', 'dhclient', dev, '-r' ]
      # No checking of return status, just trying to get
      subprocess.call( cmd )
