# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from TypeFuture import TacLazyType

AutonegMode = TacLazyType( 'Interface::AutonegMode' )
AUTONEG_CL73 = AutonegMode.anegModeClause73
AUTONEG_CL37 = AutonegMode.anegModeClause37
AUTONEG_CL28 = AutonegMode.anegModeClause28
AUTONEG_DISABLED = AutonegMode.anegModeDisabled
AUTONEG_UNSUPPORTED = AutonegMode.anegModeUnsupported

EthDuplex = TacLazyType( 'Interface::EthDuplex' )
DUPLEX_UNKNOWN = EthDuplex.duplexUnknown
DUPLEX_FULL = EthDuplex.duplexFull
DUPLEX_HALF = EthDuplex.duplexHalf

EthFecEncoding = TacLazyType( 'Interface::EthFecEncoding' )
FEC_RS528 = EthFecEncoding.fecEncodingReedSolomon
FEC_RS544 = EthFecEncoding.fecEncodingReedSolomon544
FEC_FCFEC = EthFecEncoding.fecEncodingFireCode
FEC_NOFEC = EthFecEncoding.fecEncodingDisabled

EthLaneCount = TacLazyType( 'Interface::EthLaneCount' )
LANE_COUNT_1 = EthLaneCount.laneCount1
LANE_COUNT_2 = EthLaneCount.laneCount2
LANE_COUNT_4 = EthLaneCount.laneCount4
LANE_COUNT_8 = EthLaneCount.laneCount8
LANE_COUNT_10 = EthLaneCount.laneCount10

EthSpeed = TacLazyType( 'Interface::EthSpeed' )
SPEED_UNKNOWN = EthSpeed.speedUnknown
SPEED_GBPS_800 = EthSpeed.speed800Gbps
SPEED_GBPS_400 = EthSpeed.speed400Gbps
SPEED_GBPS_200 = EthSpeed.speed200Gbps
SPEED_GBPS_100 = EthSpeed.speed100Gbps
SPEED_GBPS_50 = EthSpeed.speed50Gbps
SPEED_GBPS_40 = EthSpeed.speed40Gbps
SPEED_GBPS_25 = EthSpeed.speed25Gbps
SPEED_GBPS_20 = EthSpeed.speed20Gbps
SPEED_GBPS_10 = EthSpeed.speed10Gbps
SPEED_GBPS_5 = EthSpeed.speed5Gbps
SPEED_GBPS_2p5 = EthSpeed.speed2p5Gbps
SPEED_GBPS_1 = EthSpeed.speed1Gbps
SPEED_MBPS_100 = EthSpeed.speed100Mbps
SPEED_MBPS_10 = EthSpeed.speed10Mbps
SPEED_GBPS_HG_106 = EthSpeed.speedHg106Gbps
SPEED_GBPS_HG_42 = EthSpeed.speedHg42Gbps
SPEED_GBPS_HG_53 = EthSpeed.speedHg53Gbps
SPEED_GBPS_HG_27 = EthSpeed.speedHg27Gbps
SPEED_GBPS_HG_21 = EthSpeed.speedHg21Gbps
SPEED_GBPS_HG_11 = EthSpeed.speedHg11Gbps

SpeedCompatSetting = TacLazyType( "Interface::SpeedCompatSetting" )
COMPAT_UNKNOWN = SpeedCompatSetting.compatibilityUnknown
COMPAT_GBPS_100 = SpeedCompatSetting.compatibility100g
COMPAT_GBPS_50 = SpeedCompatSetting.compatibility50g
COMPAT_GBPS_25 = SpeedCompatSetting.compatibility25g
COMPAT_GBPS_10 = SpeedCompatSetting.compatibility10g

SerdesGroupMode = TacLazyType( 'Hardware::Phy::SerdesGroupMode',
                               returnValueConst=True )
UNKNOWN_SERDES_GROUP_MODE = SerdesGroupMode()
G800_8_RS544 = SerdesGroupMode( SPEED_GBPS_800, FEC_RS544,
                                LANE_COUNT_8, DUPLEX_FULL )
G400_4_RS544 = SerdesGroupMode( SPEED_GBPS_400, FEC_RS544,
                                LANE_COUNT_4, DUPLEX_FULL )
G400_8_RS544 = SerdesGroupMode( SPEED_GBPS_400, FEC_RS544,
                                LANE_COUNT_8, DUPLEX_FULL )
G200_2_RS544 = SerdesGroupMode( SPEED_GBPS_200, FEC_RS544,
                                LANE_COUNT_2, DUPLEX_FULL )
G200_4_RS544 = SerdesGroupMode( SPEED_GBPS_200, FEC_RS544,
                                LANE_COUNT_4, DUPLEX_FULL )
G100_1_RS544 = SerdesGroupMode( SPEED_GBPS_100, FEC_RS544,
                                LANE_COUNT_1, DUPLEX_FULL )
G100_2_RS544 = SerdesGroupMode( SPEED_GBPS_100, FEC_RS544,
                                LANE_COUNT_2, DUPLEX_FULL )
G100_4_RS528 = SerdesGroupMode( SPEED_GBPS_100, FEC_RS528,
                                LANE_COUNT_4, DUPLEX_FULL )
G100_4_NOFEC = SerdesGroupMode( SPEED_GBPS_100, FEC_NOFEC,
                                LANE_COUNT_4, DUPLEX_FULL )
G50_1_RS544 = SerdesGroupMode( SPEED_GBPS_50, FEC_RS544,
                               LANE_COUNT_1, DUPLEX_FULL )
G50_2_RS528 = SerdesGroupMode( SPEED_GBPS_50, FEC_RS528,
                               LANE_COUNT_2, DUPLEX_FULL )
G50_2_FCFEC = SerdesGroupMode( SPEED_GBPS_50, FEC_FCFEC,
                               LANE_COUNT_2, DUPLEX_FULL )
G50_2_NOFEC = SerdesGroupMode( SPEED_GBPS_50, FEC_NOFEC,
                               LANE_COUNT_2, DUPLEX_FULL )
G40_4_FCFEC = SerdesGroupMode( SPEED_GBPS_40, FEC_FCFEC,
                               LANE_COUNT_4, DUPLEX_FULL )
G40_4_NOFEC = SerdesGroupMode( SPEED_GBPS_40, FEC_NOFEC,
                               LANE_COUNT_4, DUPLEX_FULL )
G40_2_NOFEC = SerdesGroupMode( SPEED_GBPS_40, FEC_NOFEC,
                               LANE_COUNT_2, DUPLEX_FULL )
G25_1_RS528 = SerdesGroupMode( SPEED_GBPS_25, FEC_RS528,
                               LANE_COUNT_1, DUPLEX_FULL )
G25_1_FCFEC = SerdesGroupMode( SPEED_GBPS_25, FEC_FCFEC,
                               LANE_COUNT_1, DUPLEX_FULL )
G25_1_NOFEC = SerdesGroupMode( SPEED_GBPS_25, FEC_NOFEC,
                               LANE_COUNT_1, DUPLEX_FULL )
G10_1_FCFEC = SerdesGroupMode( SPEED_GBPS_10, FEC_FCFEC,
                               LANE_COUNT_1, DUPLEX_FULL )
G10_1_NOFEC = SerdesGroupMode( SPEED_GBPS_10, FEC_NOFEC,
                               LANE_COUNT_1, DUPLEX_FULL )
G5_1_NOFEC = SerdesGroupMode( SPEED_GBPS_5, FEC_NOFEC,
                              LANE_COUNT_1, DUPLEX_FULL )
G2P5_1_NOFEC = SerdesGroupMode( SPEED_GBPS_2p5, FEC_NOFEC,
                                LANE_COUNT_1, DUPLEX_FULL )
G1_1_NOFEC = SerdesGroupMode( SPEED_GBPS_1, FEC_NOFEC,
                              LANE_COUNT_1, DUPLEX_FULL )
M100_1_NOFEC = SerdesGroupMode( SPEED_MBPS_100, FEC_NOFEC,
                                LANE_COUNT_1, DUPLEX_FULL )
M100_1_NOFEC_HALF = SerdesGroupMode( SPEED_MBPS_100, FEC_NOFEC,
                                     LANE_COUNT_1, DUPLEX_HALF )
M10_1_NOFEC = SerdesGroupMode( SPEED_MBPS_10, FEC_NOFEC,
                               LANE_COUNT_1, DUPLEX_FULL )
M10_1_NOFEC_HALF = SerdesGroupMode( SPEED_MBPS_10, FEC_NOFEC,
                                    LANE_COUNT_1, DUPLEX_HALF )
HG_G106_4_NOFEC = SerdesGroupMode( SPEED_GBPS_HG_106, FEC_NOFEC,
                                   LANE_COUNT_4, DUPLEX_FULL )
HG_G53_2_NOFEC = SerdesGroupMode( SPEED_GBPS_HG_53, FEC_NOFEC,
                                  LANE_COUNT_2, DUPLEX_FULL )
HG_G42_4_NOFEC = SerdesGroupMode( SPEED_GBPS_HG_42, FEC_NOFEC,
                                  LANE_COUNT_4, DUPLEX_FULL )
HG_G27_1_NOFEC = SerdesGroupMode( SPEED_GBPS_HG_27, FEC_NOFEC,
                                  LANE_COUNT_1, DUPLEX_FULL )
HG_G21_2_NOFEC = SerdesGroupMode( SPEED_GBPS_HG_21, FEC_NOFEC,
                                  LANE_COUNT_2, DUPLEX_FULL )
HG_G11_1_NOFEC = SerdesGroupMode( SPEED_GBPS_HG_11, FEC_NOFEC,
                                  LANE_COUNT_1, DUPLEX_FULL )

ChannelMode = TacLazyType( 'Hardware::Phy::ChannelMode' )
