# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=consider-using-f-string

class InactiveThreshold():
   letterCode = "I"
   fullName = "Inactive"
   summary = ( "%s - %s - threshold exceeds the maximum VOQ tail drop threshold" % \
               ( letterCode, fullName ) ) + " (%d)"
   message = "The specified threshold(s) exceed the maximum VOQ tail drop " + \
             "threshold for interfaces: %s. To see the VOQ tail drop threshold " + \
             "for each interface, run the \"show platform sand voq tail-drop\"" + \
             "command."

   def getSummary( self, maxQueueLen ):
      return self.summary % maxQueueLen

   def getLetterCode( self, maxQueueLen ):
      return "%s (%d)" % ( self.letterCode, maxQueueLen )
