#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   #-------------------------------------------------------------------------
   # Acl runs unconditionally on "AllSupervisors"
   #-------------------------------------------------------------------------
   roleName = context.allSupervisorsRoleName

   agentName = "Acl"
   agentCfg = { "name" : agentName,
                "exe" : "/usr/bin/Acl",
                "argv" : [],
                # BUG853905: The Acl agent is (unfortunately) designed to use
                # iptables-restore to (re)program any and all iptables rule changes
                # in a _synchronous_ manner. That is, it uses popen() and blocks on
                # pclose(), not yielding to the activity loop. As  iptables-restore
                # requires the rtnl_lock when generating particular rules (e.g.
                # resolving L4 port such as "179" or "bgp" to 179), it can be blocked
                # by other processes in the kernel holding this lock.
                #
                # In the case of this bug, iptables-restore was blocked for dozens of
                # seconds, resulting in a SIGQUIT. When the Acl agent restarts, it
                # does not reconcile iptables state in a make-before-break fashion,
                # and may transiently drop packets which should be permitted. This
                # can be problematic for timing-sensitive control-plane protocols
                # such as BFD which are subject to iptables rules.
                #
                # In order to reduce the probability of this failure mode, the
                # heartbeat period is set to 180 seconds (3 minutes).
                #
                # This value was # chosen arbitrarily, and tested to ensure it
                # preventted BUG853905.
                "heartbeatPeriod" : 180,
                "runnability": [ ] }
   context.agentConfigIs( roleName, agentCfg )
