#!/usr/bin/env python3
# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Swag

# pkgdeps: import LauncherContext

def Plugin( context ):
   if not Swag.isMember():
      return

   agentName = 'AgentInfoPub'
   agentCfg = {
      'name': agentName,
      'exe': '/usr/bin/AgentInfoPub',
      'argv': [ '--smid=%(smid)s' ],
      'heartbeatPeriod': 30,
      'runnability': [],
      'swagRole': context.allSwagMembers,
   }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
