#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   # Configure the AgentMonitor to run on AllCells
   agentName = 'AgentMonitor'
   agentCfg = { 'name': agentName,
                'exe': '/usr/bin/AgentMonitor',
                'argv': [],
                'heartbeatPeriod': 30 }
   # To enable agent ping & AgentSyncResponder functionality,
   # AgentMonitor runs on all supervisors in SSO mode.
   roleName = { 'sso': context.allSupervisorsRoleName,
                'rpr': context.activeSupervisorRoleName }
   context.agentConfigIs( roleName, agentCfg )
