#!/usr/bin/env python3
# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Generate dependency on Launcher
# pkgdeps: import LauncherContext
# pkgdeps: rpmwith %{_libdir}/SysdbMountProfiles/LauncherOpenConfig
from OpenConfigLauncherLib import openConfigRunnability

def Plugin( context ):
   terminAttrPath = 'cell/%cellId/launcher/LaunchedAgents/TerminAttr'
   # AirStream is runnable if:
   # - TerminAttr is configured to run under LaunchedAgents path, OR
   # - OpenConfig is runnable, OR
   # - Octa is runnable
   runnability = [ { 'qualPath': terminAttrPath },
                   openConfigRunnability( context ) ]

   agentName = "AirStream"
   agentCfg = { "name": agentName,
                "exe": "/usr/bin/AirStream",
                "argv": [],
                "heartbeatPeriod": 30,
                "runnability": runnability }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
